/*
 * Decompiled with CFR 0.152.
 */
package com.day.util.diff;

import com.day.util.diff.DiffWriter;
import com.day.util.diff.Range;
import java.io.IOException;

public class Hunk {
    public static final int UNMODIFIED = 0;
    public static final int INSERTED = 1;
    public static final int DELETED = 2;
    public static final int CHANGED = 3;
    public final Range left;
    public final Range right;
    public final int type;
    private Hunk prev;
    private Hunk next;

    public Hunk(Range left, Range right, int type, Hunk prev) {
        this.left = left;
        this.right = right;
        this.prev = prev;
        this.type = type;
        if (prev != null) {
            prev.next = this;
        }
    }

    public Hunk prev() {
        return this.prev;
    }

    public Hunk next() {
        return this.next;
    }

    public Hunk write(DiffWriter out, int numContextLines) throws IOException {
        if (this.type == 0) {
            return this.next;
        }
        Hunk last = this.next;
        Hunk prevLast = this;
        while (last != null && (last.type != 0 || last.left.len() <= 2 * numContextLines && last.next != null)) {
            prevLast = last;
            last = last.next;
        }
        Range prevRange = this.prev == null ? new Range(this.left.doc, this.left.low, this.left.low) : new Range(this.left.doc, Math.max(this.left.low - numContextLines, 0), this.left.low);
        Range lastRange = last == null ? new Range(this.left.doc, prevLast.left.high, prevLast.left.high) : new Range(this.left.doc, last.left.low, Math.min(last.left.high, last.left.low + numContextLines));
        int prevLen0 = prevRange.len();
        int lastLen0 = lastRange.len();
        int prevLen1 = prevRange.len();
        int lastLen1 = lastRange.len();
        if (this.left.len() == 0 && numContextLines == 0) {
            prevLen0 = 1;
            --lastLen0;
        }
        if (this.right.len() == 0 && numContextLines == 0) {
            prevLen1 = 1;
            --lastLen1;
        }
        Range newLeft = new Range(this.left.doc, this.left.low - prevLen0, prevLast.left.high + lastLen0);
        Range newRight = new Range(this.right.doc, this.right.low - prevLen1, prevLast.right.high + lastLen1);
        out.write("@@ -");
        out.write(newLeft.toRangeString());
        out.write(" +");
        out.write(newRight.toRangeString());
        out.write(" @@");
        out.writeNewLine();
        Hunk.writeData(out, prevRange, " ");
        Hunk h = this;
        while (h != last) {
            h.writeBody(out);
            h = h.next;
        }
        Hunk.writeData(out, lastRange, " ");
        return last;
    }

    private void writeBody(DiffWriter out) throws IOException {
        if (this.type == 0) {
            Hunk.writeData(out, this.left, " ");
        }
        if ((this.type & 2) != 0) {
            Hunk.writeData(out, this.left, "-");
        }
        if ((this.type & 1) != 0) {
            Hunk.writeData(out, this.right, "+");
        }
    }

    private static void writeData(DiffWriter out, Range range, String prefix) throws IOException {
        for (int i = range.low; i < range.high; ++i) {
            out.write(prefix);
            out.write(range.doc.getElements()[i].getString());
        }
    }
}

