/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.NodeStateFacetsConfig;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.SecureSortedSetDocValuesFacetCounts;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.StatisticalSortedSetDocValuesFacetCounts;
import org.apache.jackrabbit.oak.plugins.index.search.FieldNames;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.MultiFacets;
import org.apache.lucene.facet.sortedset.DefaultSortedSetDocValuesReaderState;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetCounts;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacetHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FacetHelper.class);
    public static final String ATTR_FACET_FIELDS = "oak.facet.fields";
    private static final Facets NULL_FACETS = new Facets(){

        @Override
        public FacetResult getTopChildren(int topN, String dim, String ... path) {
            return null;
        }

        @Override
        public Number getSpecificValue(String dim, String ... path) {
            return null;
        }

        @Override
        public List<FacetResult> getAllDims(int topN) {
            return null;
        }
    };

    private FacetHelper() {
    }

    public static FacetsConfig getFacetsConfig(NodeBuilder definition) {
        return new NodeStateFacetsConfig(definition);
    }

    public static Facets getFacets(IndexSearcher searcher, Query query, QueryIndex.IndexPlan plan, IndexDefinition.SecureFacetConfiguration secureFacetConfiguration) throws IOException {
        Facets facets = null;
        List facetFields = (List)plan.getAttribute(ATTR_FACET_FIELDS);
        if (facetFields != null && facetFields.size() > 0) {
            HashMap<String, Facets> facetsMap = new HashMap<String, Facets>();
            for (String facetField : facetFields) {
                FacetsCollector facetsCollector = new FacetsCollector();
                try {
                    DefaultSortedSetDocValuesReaderState state = new DefaultSortedSetDocValuesReaderState(searcher.getIndexReader(), FieldNames.createFacetFieldName((String)facetField));
                    FacetsCollector.search(searcher, query, null, 1, Sort.INDEXORDER, facetsCollector);
                    switch (secureFacetConfiguration.getMode()) {
                        case INSECURE: {
                            facets = new SortedSetDocValuesFacetCounts(state, facetsCollector);
                            break;
                        }
                        case STATISTICAL: {
                            facets = new StatisticalSortedSetDocValuesFacetCounts(state, facetsCollector, plan.getFilter(), secureFacetConfiguration);
                            break;
                        }
                        default: {
                            facets = new SecureSortedSetDocValuesFacetCounts(state, facetsCollector, plan.getFilter());
                        }
                    }
                    facetsMap.put(facetField, facets);
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn("facets for {} not yet indexed", (Object)facetField);
                }
            }
            if (facetsMap.size() > 0) {
                facets = new MultiFacets(facetsMap, NULL_FACETS);
            }
        }
        return facets;
    }

    public static String parseFacetField(String columnName) {
        return columnName.substring("rep:facet".length() + 1, columnName.length() - 1);
    }
}

