/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.base;

import java.util.Date;
import java.util.concurrent.locks.Lock;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.DiscoveryService;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.base.ViewStateManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MinEventDelayHandler {
    private static final Logger logger = LoggerFactory.getLogger(MinEventDelayHandler.class);
    private boolean isDelaying = false;
    private final Scheduler scheduler;
    private final long minEventDelaySecs;
    private DiscoveryService discoveryService;
    private ViewStateManagerImpl viewStateManager;
    private Lock lock;
    private volatile int cancelCnt = 0;

    MinEventDelayHandler(ViewStateManagerImpl viewStateManager, Lock lock, DiscoveryService discoveryService, Scheduler scheduler, long minEventDelaySecs) {
        this.viewStateManager = viewStateManager;
        this.lock = lock;
        if (discoveryService == null) {
            throw new IllegalArgumentException("discoveryService must not be null");
        }
        this.discoveryService = discoveryService;
        if (scheduler == null) {
            throw new IllegalArgumentException("scheduler must not be null");
        }
        this.scheduler = scheduler;
        if (minEventDelaySecs <= 0L) {
            throw new IllegalArgumentException("minEventDelaySecs must be greater than 0 (is " + minEventDelaySecs + ")");
        }
        this.minEventDelaySecs = minEventDelaySecs;
    }

    boolean handlesNewView(BaseTopologyView newView) {
        if (this.isDelaying) {
            logger.info("handleNewView: already delaying, ignoring new view meanwhile");
            return true;
        }
        if (!this.viewStateManager.hadPreviousView()) {
            logger.info("handlesNewView: never had a previous view, hence no delaying applicable");
            return false;
        }
        if (this.viewStateManager.onlyDiffersInProperties(newView)) {
            logger.info("handlesNewView: only properties differ, hence no delaying applicable");
            return false;
        }
        if (this.viewStateManager.unchanged(newView)) {
            logger.trace("handlesNewView: view is unchanged, hence no delaying applicable");
            return false;
        }
        if (!this.triggerAsyncDelaying(newView)) {
            logger.info("handleNewView: could not trigger async delaying, sending new view now.");
            this.viewStateManager.handleNewViewNonDelayed(newView);
        } else {
            this.viewStateManager.handleChanging();
        }
        return true;
    }

    private boolean triggerAsyncDelaying(BaseTopologyView newView) {
        final int validCancelCnt = this.cancelCnt;
        boolean triggered = this.runAfter(this.minEventDelaySecs, new Runnable(){

            @Override
            public void run() {
                MinEventDelayHandler.this.lock.lock();
                try {
                    if (MinEventDelayHandler.this.cancelCnt != validCancelCnt) {
                        logger.info("asyncDelay.run: got cancelled (validCancelCnt=" + validCancelCnt + ", cancelCnt=" + MinEventDelayHandler.this.cancelCnt + "), quitting.");
                        return;
                    }
                    MinEventDelayHandler.this.isDelaying = false;
                    TopologyView t = MinEventDelayHandler.this.discoveryService.getTopology();
                    if (!(t instanceof BaseTopologyView)) {
                        logger.error("asyncDelay.run: done delaying. topology not of type BaseTopologyView: " + t);
                        return;
                    }
                    BaseTopologyView topology = (BaseTopologyView)t;
                    if (topology.isCurrent()) {
                        logger.info("asyncDelay.run: done delaying. got new view: " + topology.toShortString());
                        MinEventDelayHandler.this.viewStateManager.handleNewViewNonDelayed(topology);
                    } else {
                        logger.info("asyncDelay.run: done delaying. new view (still/again) not current, delaying again");
                        MinEventDelayHandler.this.triggerAsyncDelaying(topology);
                    }
                }
                catch (RuntimeException re) {
                    logger.error("RuntimeException: " + re, re);
                    throw re;
                }
                catch (Error er) {
                    logger.error("Error: " + er, er);
                    throw er;
                }
                finally {
                    MinEventDelayHandler.this.lock.unlock();
                }
            }
        });
        logger.info("triggerAsyncDelaying: asynch delaying of " + this.minEventDelaySecs + " triggered: " + triggered);
        if (triggered) {
            this.isDelaying = true;
        }
        return triggered;
    }

    private boolean runAfter(long seconds, Runnable runnable) {
        Scheduler theScheduler = this.scheduler;
        if (theScheduler == null) {
            logger.info("runAfter: no scheduler set");
            return false;
        }
        logger.trace("runAfter: trying with scheduler.fireJob");
        Date date = new Date(System.currentTimeMillis() + seconds * 1000L);
        try {
            theScheduler.fireJobAt(null, runnable, null, date);
            return true;
        }
        catch (Exception e) {
            logger.info("runAfter: could not schedule a job: " + e);
            return false;
        }
    }

    boolean isDelaying() {
        return this.isDelaying;
    }

    public void cancelDelaying() {
        logger.info("cancelDelaying: flagging cancelCnt as invalid: " + this.cancelCnt);
        ++this.cancelCnt;
        this.isDelaying = false;
    }
}

