/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.sites.ui.models.admin.security.permission;

import com.day.cq.security.util.CqActions;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class})
public final class UserAllowedActions {
    @Self
    private SlingHttpServletRequest slingRequest;
    @Inject
    private ResourceResolver resolver;
    @ValueMapValue(name="class")
    private String classNames;
    private CqActions cqActions;
    private boolean aclEdit;

    @PostConstruct
    protected void initModel() throws RepositoryException {
        Session session = this.resolver.adaptTo(Session.class);
        String resourcePath = this.slingRequest.getParameter("item");
        if (StringUtils.isNotEmpty(resourcePath) && ((JackrabbitSession)session).hasPermission(resourcePath, "read_access_control")) {
            this.cqActions = new CqActions(session);
            Collection<String> principalAllowedActions = this.cqActions.getAllowedActions(resourcePath, Collections.singleton(this.slingRequest.getUserPrincipal()));
            this.aclEdit = principalAllowedActions.contains("acl_edit");
        }
    }

    public boolean canEditAcl() {
        return this.aclEdit;
    }

    public String getClassNames() {
        return this.classNames;
    }
}

