/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.TextPosn;
import com.adobe.xfa.text.TextStream;

public class TextField
extends TextStream {
    public static final int EMBEDTYPE_SOM = 0;
    public static final int EMBEDTYPE_URI = 1;
    public static final int EMBED_RAW = 0;
    public static final int EMBED_FORMATTED = 1;
    private TextPosn moPosn;
    private int meEmbedMode = 1;
    private int meEmbedType = 0;
    private String msExpression = "";

    public TextField() {
    }

    public TextField(TextField oSource) {
        super(oSource, null);
        this.meEmbedMode = oSource.meEmbedMode;
        this.meEmbedType = oSource.meEmbedType;
        this.msExpression = oSource.msExpression;
    }

    public TextField(String sFieldText, int eEmbedMode, int eEmbedType) {
        super(sFieldText);
        this.meEmbedMode = eEmbedMode;
        this.meEmbedType = eEmbedType;
    }

    public TextField(String sFieldText, int eEmbedMode, int eEmbedType, String sExpression) {
        this(sFieldText, eEmbedMode, eEmbedType);
        this.msExpression = sExpression;
    }

    public TextField(int eEmbedMode, int eEmbedType, String sExpression) {
        this.meEmbedMode = eEmbedMode;
        this.meEmbedType = eEmbedType;
        this.msExpression = sExpression;
    }

    public TextField(String sFieldText) {
        super(sFieldText);
    }

    public void copyFrom(TextField oSource) {
        super.copyFrom(oSource);
        this.meEmbedType = oSource.meEmbedType;
        this.meEmbedMode = oSource.meEmbedMode;
        this.msExpression = oSource.msExpression;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        TextField test = (TextField)object;
        if (this.msExpression != null && test.msExpression != null ? !this.msExpression.equals(test.msExpression) : this.msExpression != test.msExpression) {
            return false;
        }
        return this.meEmbedType == test.meEmbedType && this.meEmbedMode == test.meEmbedMode;
    }

    @Override
    public int hashCode() {
        int hash = 53;
        if (this.msExpression != null) {
            hash = hash * 31 ^ this.msExpression.hashCode();
        }
        hash = hash * 31 ^ super.hashCode();
        hash = hash * 31 ^ this.meEmbedType;
        hash = hash * 31 ^ this.meEmbedMode;
        return hash;
    }

    public boolean notEqual(TextField oCompare) {
        return !this.equals(oCompare);
    }

    public boolean isEqual(TextField oCompare) {
        return this.equals(oCompare);
    }

    public TextField cloneField() {
        return new TextField(this);
    }

    @Override
    public TextPosn position() {
        return this.moPosn == null || this.moPosn.stream() == null ? null : this.moPosn;
    }

    public void setEmbedMode(int eEmbedMode) {
        this.meEmbedMode = eEmbedMode;
    }

    public int getEmbedMode() {
        return this.meEmbedMode;
    }

    public void setEmbedType(int eEmbedType) {
        this.meEmbedType = eEmbedType;
    }

    public int getEmbedType() {
        return this.meEmbedType;
    }

    public void setExpression(String sExpression) {
        this.msExpression = sExpression;
    }

    public String getExpression() {
        return this.msExpression;
    }

    void positionSet(TextStream poStream, int nIndex) {
        if (poStream == null) {
            this.moPosn = null;
        } else if (this.moPosn == null) {
            this.moPosn = new TextPosn(poStream, nIndex, 0);
        } else {
            this.moPosn.associate(poStream, nIndex, 0);
        }
    }
}

