/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.schema.rng.model;

import com.adobe.xmp.schema.rng.model.DatatypeInfo;
import com.adobe.xmp.schema.rng.model.ParamInfo;
import com.adobe.xmp.schema.rng.parser.constants.RNGSymbol;

public class ParamInfoImpl
implements ParamInfo {
    private final RNGSymbol mType;
    private final Object mValue;
    private String mValueType;
    private final String mLabel;
    public static final ParamInfoImpl PARAM_ALL_TEXT = new ParamInfoImpl("text", null);
    public static final ParamInfoImpl PARAM_ALL_INTEGER = new ParamInfoImpl("INTEGER", null);
    public static final ParamInfoImpl PARAM_ALL_DOUBLE = new ParamInfoImpl("DOUBLE", null);
    public static final ParamInfoImpl PARAM_ALL_BOOLEAN = new ParamInfoImpl("BOOLEAN", null);

    public ParamInfoImpl(String type, Object value, String valueType, String label) {
        this.mType = RNGSymbol.toSymbol((String)type);
        this.mValue = value;
        this.mValueType = valueType;
        this.mLabel = label;
    }

    public ParamInfoImpl(String type, Object value) {
        this(type, value, null, "");
    }

    public RNGSymbol getType() {
        return this.mType;
    }

    public Object getValue() {
        return this.mValue;
    }

    public String getValueType() {
        return this.mValueType;
    }

    public String getXMPValueType() {
        return DatatypeInfo.kXMLDatatypes.get(this.mValueType);
    }

    public String getStringValue() {
        return this.mValue instanceof String ? (String)this.mValue : null;
    }

    public boolean equals(ParamInfo param) {
        boolean ret = false;
        if (param instanceof ParamInfoImpl) {
            ParamInfoImpl info = (ParamInfoImpl)param;
            ret = this.mType == info.mType && this.mValue.equals(info.mValue);
        }
        return ret;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nParamInfo : (" + this.mType + ", ");
        str.append(this.mValue + ", ");
        str.append(this.mValueType + ", ");
        str.append(this.mLabel + " )");
        return str.toString();
    }
}

