/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.workflow.process;

import com.adobe.granite.workflow.collection.ResourceCollection;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCollectionHelper {
    private static final Logger log = LoggerFactory.getLogger(ResourceCollectionHelper.class);
    private static final String[] ALLOWED_NODE_PRIMARY_AND_RESOURCE_TYPES = new String[]{"cq:Page", "dam:Asset", "wcm/core/components/policy/policy", "cq/tagging/components/tag"};

    public static List<String> getPaths(String path, List<ResourceCollection> rcCollections) {
        ArrayList<String> paths = new ArrayList<String>();
        if (rcCollections == null || rcCollections.size() == 0) {
            paths.add(path);
        } else {
            log.debug("ResourceCollections detected");
            for (ResourceCollection rcCollection : rcCollections) {
                try {
                    List<Node> members = rcCollection.list(ALLOWED_NODE_PRIMARY_AND_RESOURCE_TYPES);
                    for (Node member : members) {
                        String mPath = member.getPath();
                        paths.add(mPath);
                    }
                }
                catch (RepositoryException re) {
                    log.error("Cannot build path list out of the resource collection " + rcCollection.getPath());
                }
            }
        }
        return paths;
    }
}

