/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import com.google.common.util.concurrent.AbstractListeningExecutorService;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class SameThreadExecutorService
extends AbstractListeningExecutorService {
    private final Lock lock = new ReentrantLock();
    private final Condition termination = this.lock.newCondition();
    private int runningTasks = 0;
    private boolean shutdown = false;

    SameThreadExecutorService() {
    }

    @Override
    public void execute(Runnable command) {
        this.startTask();
        try {
            command.run();
        }
        finally {
            this.endTask();
        }
    }

    @Override
    public boolean isShutdown() {
        this.lock.lock();
        try {
            boolean bl = this.shutdown;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.lock.lock();
        try {
            this.shutdown = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        this.lock.lock();
        try {
            boolean bl = this.shutdown && this.runningTasks == 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        this.lock.lock();
        try {
            while (true) {
                if (this.isTerminated()) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.termination.awaitNanos(nanos);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void startTask() {
        this.lock.lock();
        try {
            if (this.isShutdown()) {
                throw new RejectedExecutionException("Executor already shutdown");
            }
            ++this.runningTasks;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void endTask() {
        this.lock.lock();
        try {
            --this.runningTasks;
            if (this.isTerminated()) {
                this.termination.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

