/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.importer;

import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

public class AsyncLaneSwitcher {
    static final String ASYNC_PREVIOUS = "async-previous";
    static final String ASYNC_PREVIOUS_NONE = "none";
    private static final String TEMP_LANE_PREFIX = "temp-";

    public static void switchLane(NodeBuilder idxBuilder, String laneName) {
        PropertyState currentAsyncState = idxBuilder.getProperty("async");
        PropertyState newAsyncState = PropertyStates.createProperty("async", (Object)laneName, Type.STRING);
        if (idxBuilder.hasProperty(ASYNC_PREVIOUS)) {
            return;
        }
        PropertyState previousAsyncState = currentAsyncState == null ? PropertyStates.createProperty(ASYNC_PREVIOUS, ASYNC_PREVIOUS_NONE) : AsyncLaneSwitcher.clone(ASYNC_PREVIOUS, currentAsyncState);
        idxBuilder.setProperty(previousAsyncState);
        idxBuilder.setProperty(newAsyncState);
    }

    public static String getTempLaneName(String laneName) {
        return TEMP_LANE_PREFIX + laneName;
    }

    public static void revertSwitch(NodeBuilder idxBuilder, String indexPath) {
        PropertyState previousAsync = idxBuilder.getProperty(ASYNC_PREVIOUS);
        Preconditions.checkState(previousAsync != null, "No previous async state property found for index [%s]", indexPath);
        if (AsyncLaneSwitcher.isNone(previousAsync)) {
            idxBuilder.removeProperty("async");
        } else {
            idxBuilder.setProperty(AsyncLaneSwitcher.clone("async", previousAsync));
        }
        idxBuilder.removeProperty(ASYNC_PREVIOUS);
    }

    public static boolean isNone(PropertyState previousAsync) {
        return !previousAsync.isArray() && ASYNC_PREVIOUS_NONE.equals(previousAsync.getValue(Type.STRING));
    }

    private static PropertyState clone(String newName, PropertyState currentAsyncState) {
        PropertyState clonedState = currentAsyncState.isArray() ? PropertyStates.createProperty(newName, currentAsyncState.getValue(Type.STRINGS), Type.STRINGS) : PropertyStates.createProperty(newName, (Object)currentAsyncState.getValue(Type.STRING), Type.STRING);
        return clonedState;
    }
}

