/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.provisioning.model;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.provisioning.model.Commentable;

public class Configuration
extends Commentable
implements Comparable<Configuration> {
    private final String pid;
    private final String factoryPid;
    private final Dictionary<String, Object> properties = new Hashtable<String, Object>();

    public Configuration(String pid, String factoryPid) {
        this.pid = pid != null ? pid.trim() : null;
        this.factoryPid = factoryPid != null ? factoryPid.trim() : null;
    }

    private int compareString(String a, String b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    @Override
    public int compareTo(Configuration o) {
        int result = this.compareString(this.factoryPid, o.factoryPid);
        if (result == 0) {
            result = this.compareString(this.pid, o.pid);
        }
        return result;
    }

    public String getPid() {
        return this.pid;
    }

    public String getFactoryPid() {
        return this.factoryPid;
    }

    public boolean isSpecial() {
        return this.pid != null && this.pid.startsWith(":");
    }

    public Dictionary<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return "Configuration [pid=" + this.pid + ", factoryPid=" + this.factoryPid + ", properties=" + this.properties + (this.getLocation() != null ? ", location=" + this.getLocation() : "") + "]";
    }
}

