/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.text;

import com.adobe.agl.impl.ICUResourceBundle;
import com.adobe.agl.util.Currency;
import com.adobe.agl.util.ULocale;
import com.adobe.agl.util.UResourceBundle;
import java.io.Serializable;
import java.text.ChoiceFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;

public class DecimalFormatSymbols
implements Serializable,
Cloneable {
    private char zeroDigit;
    private char groupingSeparator;
    private char decimalSeparator;
    private char perMill;
    private char percent;
    private char digit;
    private char sigDigit;
    private char patternSeparator;
    private String infinity;
    private String NaN;
    private char minusSign;
    private String currencySymbol;
    private String intlCurrencySymbol;
    private char monetarySeparator;
    private char monetaryGroupingSeparator;
    private String exponentSeparator;
    private char padEscape;
    private char plusSign;
    private Locale requestedLocale;
    private ULocale ulocale;
    private int serialVersionOnStream = 5;
    private static final Hashtable cachedLocaleData = new Hashtable(3);
    private String currencyPattern = null;
    private ULocale validLocale;
    private ULocale actualLocale;
    private transient Currency currency;

    public DecimalFormatSymbols() {
        this.initialize(ULocale.getDefault());
    }

    public DecimalFormatSymbols(ULocale locale) {
        this.initialize(locale);
    }

    public char getZeroDigit() {
        return this.zeroDigit;
    }

    public char getSignificantDigit() {
        return this.sigDigit;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public char getPerMill() {
        return this.perMill;
    }

    public char getPercent() {
        return this.percent;
    }

    public char getDigit() {
        return this.digit;
    }

    public char getPatternSeparator() {
        return this.patternSeparator;
    }

    public String getInfinity() {
        return this.infinity;
    }

    public String getNaN() {
        return this.NaN;
    }

    public char getMinusSign() {
        return this.minusSign;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currency) {
        this.currencySymbol = currency;
    }

    public String getInternationalCurrencySymbol() {
        return this.intlCurrencySymbol;
    }

    public void setInternationalCurrencySymbol(String currency) {
        this.intlCurrencySymbol = currency;
    }

    public char getMonetaryDecimalSeparator() {
        return this.monetarySeparator;
    }

    public char getMonetaryGroupingSeparator() {
        return this.monetaryGroupingSeparator;
    }

    public String getExponentSeparator() {
        return this.exponentSeparator;
    }

    public char getPlusSign() {
        return this.plusSign;
    }

    public char getPadEscape() {
        return this.padEscape;
    }

    public ULocale getULocale() {
        return this.ulocale;
    }

    public Object clone() {
        try {
            return (DecimalFormatSymbols)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DecimalFormatSymbols other = (DecimalFormatSymbols)obj;
        return this.zeroDigit == other.zeroDigit && this.groupingSeparator == other.groupingSeparator && this.decimalSeparator == other.decimalSeparator && this.percent == other.percent && this.perMill == other.perMill && this.digit == other.digit && this.minusSign == other.minusSign && this.patternSeparator == other.patternSeparator && this.infinity.equals(other.infinity) && this.NaN.equals(other.NaN) && this.currencySymbol.equals(other.currencySymbol) && this.intlCurrencySymbol.equals(other.intlCurrencySymbol) && this.padEscape == other.padEscape && this.plusSign == other.plusSign && this.exponentSeparator.equals(other.exponentSeparator) && this.monetarySeparator == other.monetarySeparator;
    }

    public int hashCode() {
        int result = this.zeroDigit;
        result = result * 37 + this.groupingSeparator;
        result = result * 37 + this.decimalSeparator;
        return result;
    }

    private void initialize(ULocale locale) {
        String currencyCode;
        this.requestedLocale = locale.toLocale();
        this.ulocale = locale;
        String[][] data = (String[][])cachedLocaleData.get(locale);
        if (data == null) {
            data = new String[1][];
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/adobe/agl/impl/data/icudt40b", locale);
            data[0] = rb.getStringArray("NumberElements");
            cachedLocaleData.put(locale, data);
        }
        String[] numberElements = data[0];
        ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/adobe/agl/impl/data/icudt40b", locale);
        ULocale uloc = r.getULocale();
        this.setLocale(uloc, uloc);
        this.decimalSeparator = numberElements[0].charAt(0);
        this.groupingSeparator = numberElements[1].charAt(0);
        this.patternSeparator = numberElements[2].charAt(0);
        this.percent = numberElements[3].charAt(0);
        this.zeroDigit = numberElements[4].charAt(0);
        this.digit = numberElements[5].charAt(0);
        this.minusSign = numberElements[6].charAt(0);
        this.exponentSeparator = numberElements[7];
        this.perMill = numberElements[8].charAt(0);
        this.infinity = numberElements[9];
        this.NaN = numberElements[10];
        this.plusSign = numberElements[11].charAt(0);
        this.padEscape = (char)42;
        this.sigDigit = (char)64;
        String currname = null;
        this.currency = Currency.getInstance(locale);
        if (this.currency != null) {
            this.intlCurrencySymbol = this.currency.getCurrencyCode();
            boolean[] isChoiceFormat = new boolean[1];
            currname = this.currency.getName(locale, 0, isChoiceFormat);
            this.currencySymbol = isChoiceFormat[0] ? new ChoiceFormat(currname).format(2.0) : currname;
        } else {
            this.intlCurrencySymbol = "XXX";
            this.currencySymbol = "\u00a4";
        }
        this.monetarySeparator = this.decimalSeparator;
        this.monetaryGroupingSeparator = this.groupingSeparator;
        Currency curr = Currency.getInstance(locale);
        if (curr != null && (currencyCode = curr.getCurrencyCode()) != null) {
            ICUResourceBundle resource = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/adobe/agl/impl/data/icudt40b", locale);
            ICUResourceBundle currencyRes = resource.getWithFallback("Currencies");
            try {
                currencyRes = currencyRes.getWithFallback(currencyCode);
                if (currencyRes.getSize() > 2) {
                    currencyRes = (ICUResourceBundle)currencyRes.get(2);
                    this.currencyPattern = currencyRes.getString(0);
                    this.monetarySeparator = currencyRes.getString(1).charAt(0);
                    this.monetaryGroupingSeparator = currencyRes.getString(2).charAt(0);
                }
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
    }

    public final ULocale getLocale(ULocale.Type type) {
        return type == ULocale.ACTUAL_LOCALE ? this.actualLocale : this.validLocale;
    }

    final void setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }
}

