/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.formcalc;

import com.adobe.xfa.formcalc.Builtins;
import com.adobe.xfa.formcalc.CalcException;
import com.adobe.xfa.formcalc.CalcParser;
import com.adobe.xfa.formcalc.CalcSymbol;
import com.adobe.xfa.formcalc.FormCalcUtil;

final class BuiltinMath {
    private BuiltinMath() {
    }

    static void Abs(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double nVal = oParser.getNumeric(oArgSym[0]);
                oRetSym = new CalcSymbol(Math.abs(nVal));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Avg(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block4: {
            oRetSym = null;
            try {
                Builtins.limitExceptionArgs(oArgSym);
                try {
                    oArgSym = Builtins.limitAllNullArgs(oParser, oArgSym);
                    oRetSym = BuiltinMath.computeAvg(oParser, oArgSym);
                }
                catch (CalcException e) {
                    oRetSym = new CalcSymbol();
                }
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block4;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Ceil(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double nVal = oParser.getNumeric(oArgSym[0]);
                oRetSym = new CalcSymbol(Math.ceil(nVal));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Count(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block4: {
            oRetSym = null;
            try {
                Builtins.limitExceptionArgs(oArgSym);
                try {
                    oArgSym = Builtins.limitAllNullArgs(oParser, oArgSym);
                    oRetSym = BuiltinMath.computeCnt(oParser, oArgSym);
                }
                catch (CalcException e) {
                    oRetSym = new CalcSymbol(0);
                }
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block4;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Floor(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double nVal = oParser.getNumeric(oArgSym[0]);
                oRetSym = new CalcSymbol(Math.floor(nVal));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Max(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block4: {
            oRetSym = null;
            try {
                Builtins.limitExceptionArgs(oArgSym);
                try {
                    oArgSym = Builtins.limitAllNullArgs(oParser, oArgSym);
                    oRetSym = BuiltinMath.computeMax(oParser, oArgSym);
                }
                catch (CalcException e) {
                    oRetSym = new CalcSymbol();
                }
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block4;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Min(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block4: {
            oRetSym = null;
            try {
                Builtins.limitExceptionArgs(oArgSym);
                try {
                    oArgSym = Builtins.limitAllNullArgs(oParser, oArgSym);
                    oRetSym = BuiltinMath.computeMin(oParser, oArgSym);
                }
                catch (CalcException e) {
                    oRetSym = new CalcSymbol();
                }
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block4;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Mod(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block3: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 2);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                double nVal1 = oParser.getNumeric(oArgSym[0]);
                double nVal2 = oParser.getNumeric(oArgSym[1]);
                if (nVal2 == 0.0) {
                    throw new CalcException();
                }
                oRetSym = new CalcSymbol(nVal1 % nVal2);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block3;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Round(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block6: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                int nPrec;
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                int n = nPrec = nArgs > 1 ? (int)oParser.getNumeric(oArgSym[1]) : 0;
                if (nPrec < 0) {
                    nPrec = 0;
                }
                if (nPrec > 12) {
                    nPrec = 12;
                }
                double nVal = oParser.getNumeric(oArgSym[0]);
                if (nPrec == 0) {
                    double nSign = nVal < 0.0 ? -1.0 : 1.0;
                    nVal = nSign * Math.abs(Math.floor(nVal + 0.5));
                    oRetSym = new CalcSymbol(nVal);
                } else {
                    String sStr = FormCalcUtil.dblToStr(nVal, nPrec);
                    oRetSym = new CalcSymbol(sStr);
                }
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block6;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Sum(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block4: {
            oRetSym = null;
            try {
                Builtins.limitExceptionArgs(oArgSym);
                try {
                    oArgSym = Builtins.limitAllNullArgs(oParser, oArgSym);
                    oRetSym = BuiltinMath.computeSum(oParser, oArgSym);
                }
                catch (CalcException e) {
                    oRetSym = new CalcSymbol();
                }
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block4;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static CalcSymbol computeAvg(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        CalcSymbol oCnt;
        CalcSymbol oSum;
        block12: {
            oSum = null;
            oCnt = null;
            oRetSym = null;
            try {
                double s = 0.0;
                int c = 0;
                block6: for (int i = 0; i < oArgSym.length; ++i) {
                    switch (oArgSym[i].getType()) {
                        case 9: {
                            CalcSymbol[] oSym = oParser.moScriptHost.getItemValue(oArgSym[i].getName(), oArgSym[i].getObjValues());
                            if (oSum != null) {
                                CalcSymbol.delete(oSum, oParser);
                            }
                            oSum = BuiltinMath.computeSum(oParser, oSym);
                            if (oCnt != null) {
                                CalcSymbol.delete(oCnt, oParser);
                            }
                            oCnt = BuiltinMath.computeCnt(oParser, oSym);
                            for (int j = oSym.length - 1; j >= 0; --j) {
                                CalcSymbol.delete(oSym[j], oParser);
                            }
                            s += oParser.getNumeric(oSum);
                            c += (int)oParser.getNumeric(oCnt);
                            continue block6;
                        }
                        case 1: {
                            continue block6;
                        }
                        default: {
                            s += oParser.getNumeric(oArgSym[i]);
                            ++c;
                        }
                    }
                }
                oRetSym = new CalcSymbol(s / (double)c);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block12;
                oParser.mbInThrow = true;
            }
        }
        if (oSum != null) {
            CalcSymbol.delete(oSum, oParser);
        }
        if (oCnt != null) {
            CalcSymbol.delete(oCnt, oParser);
        }
        return oRetSym;
    }

    static CalcSymbol computeCnt(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        CalcSymbol oCnt;
        block10: {
            oCnt = null;
            oRetSym = null;
            try {
                int c = 0;
                block6: for (int i = 0; i < oArgSym.length; ++i) {
                    switch (oArgSym[i].getType()) {
                        case 9: {
                            CalcSymbol[] oSym = oParser.moScriptHost.getItemValue(oArgSym[i].getName(), oArgSym[i].getObjValues());
                            if (oCnt != null) {
                                CalcSymbol.delete(oCnt, oParser);
                            }
                            oCnt = BuiltinMath.computeCnt(oParser, oSym);
                            for (int j = oSym.length - 1; j >= 0; --j) {
                                CalcSymbol.delete(oSym[j], oParser);
                            }
                            c += (int)oParser.getNumeric(oCnt);
                            continue block6;
                        }
                        case 1: {
                            continue block6;
                        }
                        default: {
                            oParser.getNumeric(oArgSym[i]);
                            ++c;
                        }
                    }
                }
                oRetSym = new CalcSymbol(c);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block10;
                oParser.mbInThrow = true;
            }
        }
        if (oCnt != null) {
            CalcSymbol.delete(oCnt, oParser);
        }
        return oRetSym;
    }

    static CalcSymbol computeMax(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        CalcSymbol oMax;
        block10: {
            int nArgs = oArgSym.length;
            oMax = null;
            oRetSym = null;
            try {
                double max = -1.7976931348623157E308;
                for (int i = 0; i < nArgs; ++i) {
                    double v = -1.7976931348623157E308;
                    switch (oArgSym[i].getType()) {
                        case 9: {
                            CalcSymbol[] oSym = oParser.moScriptHost.getItemValue(oArgSym[i].getName(), oArgSym[i].getObjValues());
                            if (oMax != null) {
                                CalcSymbol.delete(oMax, oParser);
                            }
                            oMax = BuiltinMath.computeMax(oParser, oSym);
                            for (int j = oSym.length - 1; j >= 0; --j) {
                                CalcSymbol.delete(oSym[j], oParser);
                            }
                            v = oParser.getNumeric(oMax);
                            break;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            v = oParser.getNumeric(oArgSym[i]);
                        }
                    }
                    if (!(v > max)) continue;
                    max = v;
                }
                oRetSym = new CalcSymbol(max);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block10;
                oParser.mbInThrow = true;
            }
        }
        if (oMax != null) {
            CalcSymbol.delete(oMax, oParser);
        }
        return oRetSym;
    }

    static CalcSymbol computeMin(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        CalcSymbol oMin;
        block10: {
            int nArgs = oArgSym.length;
            oMin = null;
            oRetSym = null;
            try {
                double min = Double.MAX_VALUE;
                for (int i = 0; i < nArgs; ++i) {
                    double v = Double.MAX_VALUE;
                    switch (oArgSym[i].getType()) {
                        case 9: {
                            CalcSymbol[] oSym = oParser.moScriptHost.getItemValue(oArgSym[i].getName(), oArgSym[i].getObjValues());
                            if (oMin != null) {
                                CalcSymbol.delete(oMin, oParser);
                            }
                            oMin = BuiltinMath.computeMin(oParser, oSym);
                            for (int j = oSym.length - 1; j >= 0; --j) {
                                CalcSymbol.delete(oSym[j], oParser);
                            }
                            v = oParser.getNumeric(oMin);
                            break;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            v = oParser.getNumeric(oArgSym[i]);
                        }
                    }
                    if (!(v < min)) continue;
                    min = v;
                }
                oRetSym = new CalcSymbol(min);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block10;
                oParser.mbInThrow = true;
            }
        }
        if (oMin != null) {
            CalcSymbol.delete(oMin, oParser);
        }
        return oRetSym;
    }

    static CalcSymbol computeSum(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        CalcSymbol oSum;
        block10: {
            int nArgs = oArgSym.length;
            oSum = null;
            oRetSym = null;
            try {
                double s = 0.0;
                block6: for (int i = 0; i < nArgs; ++i) {
                    switch (oArgSym[i].getType()) {
                        case 9: {
                            CalcSymbol[] oSym = oParser.moScriptHost.getItemValue(oArgSym[i].getName(), oArgSym[i].getObjValues());
                            if (oSum != null) {
                                CalcSymbol.delete(oSum, oParser);
                            }
                            oSum = BuiltinMath.computeSum(oParser, oSym);
                            for (int j = oSym.length - 1; j >= 0; --j) {
                                CalcSymbol.delete(oSym[j], oParser);
                            }
                            s += oParser.getNumeric(oSum);
                            continue block6;
                        }
                        case 1: {
                            continue block6;
                        }
                        default: {
                            s += oParser.getNumeric(oArgSym[i]);
                        }
                    }
                }
                oRetSym = new CalcSymbol(s);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block10;
                oParser.mbInThrow = true;
            }
        }
        if (oSum != null) {
            CalcSymbol.delete(oSum, oParser);
        }
        return oRetSym;
    }
}

