/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.compatibility;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.exec.StepExecutor;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.JavaProcess;
import com.day.cq.workflow.exec.JavaProcessExt;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.impl.CQWorkflowSessionWrapper;
import com.day.cq.workflow.impl.exec.CQWorkItemWrapper;
import com.day.cq.workflow.impl.metadata.CQMetaDataMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, label="%cq.workflow.compat.executor.name", description="%cq.workflow.compat.executor.description")
@Property(name="service.description", value={"%cq.workflow.compat.executor.description"})
@References(value={@Reference(name="WorkflowProcess", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, referenceInterface=WorkflowProcess.class, policy=ReferencePolicy.DYNAMIC), @Reference(name="Process", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, referenceInterface=JavaProcess.class, policy=ReferencePolicy.DYNAMIC)})
@Service
public class CQWorkflowProcessRunner
implements StepExecutor {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private WorkflowService cqWorkflowService;
    protected List<WorkflowProcess> workflowProcesses = new CopyOnWriteArrayList<WorkflowProcess>();
    protected List<JavaProcess> processes = new CopyOnWriteArrayList<JavaProcess>();

    public void bindWorkflowProcess(WorkflowProcess process) {
        this.workflowProcesses.add(process);
    }

    public void unbindWorkflowProcess(WorkflowProcess process) {
        this.workflowProcesses.remove(process);
    }

    public void bindProcess(JavaProcess process) {
        this.processes.add(process);
    }

    public void unbindProcess(JavaProcess process) {
        this.processes.remove(process);
    }

    @Override
    public void execute(String resource, WorkItem workItem, com.adobe.granite.workflow.WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        Object toBeExecuted = this.evaluateExecutable(resource);
        if (toBeExecuted != null) {
            try {
                CQWorkflowSessionWrapper sessionWrapper = new CQWorkflowSessionWrapper(this.cqWorkflowService, workflowSession);
                CQWorkItemWrapper workItemWrapper = new CQWorkItemWrapper(workItem);
                CQMetaDataMap cqMetaDataMap = new CQMetaDataMap(metaDataMap);
                String[] args = this.getArgs(workItem);
                if (toBeExecuted instanceof WorkflowProcess) {
                    WorkflowProcess process = (WorkflowProcess)toBeExecuted;
                    process.execute((com.day.cq.workflow.exec.WorkItem)workItemWrapper, (WorkflowSession)sessionWrapper, (com.day.cq.workflow.metadata.MetaDataMap)cqMetaDataMap);
                } else if (toBeExecuted instanceof JavaProcessExt) {
                    JavaProcessExt process = (JavaProcessExt)toBeExecuted;
                    process.execute((com.day.cq.workflow.exec.WorkItem)workItemWrapper, (WorkflowSession)sessionWrapper, args);
                } else if (toBeExecuted instanceof JavaProcess) {
                    JavaProcess process = (JavaProcess)toBeExecuted;
                    process.execute((com.day.cq.workflow.exec.WorkItem)workItemWrapper, (WorkflowSession)sessionWrapper);
                } else {
                    this.log.error("unsupported process instance " + toBeExecuted);
                }
            }
            catch (Throwable t) {
                this.log.error("Process execution resulted in an error: " + t.getMessage(), t);
                throw new WorkflowException("Failed to execute process", t);
            }
        }
    }

    @Override
    public boolean canExecute(String resource) {
        return this.evaluateExecutable(resource) != null;
    }

    private Object evaluateExecutable(String resource) {
        Object toBeExecuted = null;
        for (WorkflowProcess workfowProcess : this.workflowProcesses) {
            if (!resource.equals(workfowProcess.getClass().getName())) continue;
            toBeExecuted = workfowProcess;
            break;
        }
        if (toBeExecuted == null) {
            for (JavaProcess javaProcess : this.processes) {
                if (!resource.equals(javaProcess.getClass().getName())) continue;
                toBeExecuted = javaProcess;
                break;
            }
        }
        return toBeExecuted;
    }

    protected String[] getArgs(WorkItem item) {
        String arguments = (String)((Object)item.getNode().getMetaDataMap().get("PROCESS_ARGS", String.class));
        if (arguments != null && !arguments.equals("")) {
            return arguments.split(",");
        }
        return new String[0];
    }

    protected void bindCqWorkflowService(WorkflowService workflowService) {
        this.cqWorkflowService = workflowService;
    }

    protected void unbindCqWorkflowService(WorkflowService workflowService) {
        if (this.cqWorkflowService == workflowService) {
            this.cqWorkflowService = null;
        }
    }
}

