/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.security.token;

import com.day.crx.security.token.impl.TokenAuthenticationHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenCookie {
    private static final Logger log;
    public static final String NAME = "login-token";
    public static final String SAMESITE_ATTR_STRICT = "Strict";
    public static final String SAMESITE_ATTR_LAX = "Lax";
    public static final String SAMESITE_ATTR_NONE = "None";
    public static final String PARAM_NAME = "j_login_token";
    public static final String ATTR_NAME;
    private final Map<String, Info> infos = new TreeMap<String, Info>();
    private static final BitSet URISaveEx;
    private static final char[] hexTable;

    public Map<String, Info> getInfos() {
        return this.infos;
    }

    public static TokenCookie fromRequest(HttpServletRequest request) {
        TokenCookie t = (TokenCookie)request.getAttribute(ATTR_NAME);
        if (t == null) {
            String tokenString = TokenCookie.getCookie(request, NAME);
            if (tokenString == null || tokenString.length() == 0) {
                tokenString = request.getParameter(PARAM_NAME);
            }
            t = TokenCookie.fromString(tokenString);
            request.setAttribute(ATTR_NAME, t);
        }
        return t;
    }

    @Deprecated
    public static Info getTokenInfo(HttpServletRequest request) {
        return TokenCookie.getTokenInfo(request, TokenCookie.getPort(request));
    }

    public static Info getTokenInfo(HttpServletRequest request, String repoId) {
        Info info = (Info)request.getAttribute(Info.ATTR_NAME);
        if (info == null) {
            TokenCookie t = TokenCookie.fromRequest(request);
            info = t.getInfos().get(repoId);
            if (info == null) {
                info = Info.INVALID;
            }
            request.setAttribute(Info.ATTR_NAME, info);
        }
        return info;
    }

    public static String getPort(HttpServletRequest request) {
        String host = request.getHeader("Host");
        String port = "";
        if (host == null || host.length() == 0) {
            log.warn("Request to {} does not include a host header. Using default port.", (Object)request.getRequestURI());
        } else {
            int idx = host.indexOf(58);
            if (idx > 0) {
                port = host.substring(idx + 1);
            }
        }
        if (port.length() == 0) {
            port = request.isSecure() ? "443" : "80";
        }
        return port;
    }

    @Deprecated
    public static void update(HttpServletRequest request, HttpServletResponse response, String token, String wsp) {
        TokenCookie.update(request, response, TokenCookie.getPort(request), token, wsp, false);
    }

    public static void update(HttpServletRequest request, HttpServletResponse response, String repoId, String token, String wsp, boolean isHttpOnly) {
        TokenCookie.update(request, response, repoId, token, wsp, isHttpOnly, TokenAuthenticationHandler.getSameSiteCookieAttribute());
    }

    public static void update(HttpServletRequest request, HttpServletResponse response, String repoId, String token, String wsp, boolean isHttpOnly, String sameSiteCookieAttribute) {
        String v;
        TokenCookie t = TokenCookie.fromRequest(request);
        Info newInfo = Info.INVALID;
        if (token == null) {
            t.getInfos().remove(repoId);
        } else {
            newInfo = new Info(token, wsp);
            t.getInfos().put(repoId, newInfo);
        }
        request.setAttribute(Info.ATTR_NAME, newInfo);
        String path = request.getContextPath();
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if ((v = t.toString()).length() == 0) {
            TokenCookie.setCookie(response, NAME, v, 0, path, null, isHttpOnly, request.isSecure(), sameSiteCookieAttribute);
        } else {
            TokenCookie.setCookie(response, NAME, v, -1, path, null, isHttpOnly, request.isSecure(), sameSiteCookieAttribute);
        }
    }

    public static TokenCookie fromString(String value) {
        String[] infos;
        TokenCookie t = new TokenCookie();
        if (value == null) {
            return t;
        }
        value = TokenCookie.unescape(value);
        for (String info : infos = TokenCookie.explode(value.trim(), 59, false)) {
            String[] parts = TokenCookie.explode(info.trim(), 58, true);
            if (parts.length != 3) {
                log.warn("invalid value in cookie: {}", (Object)info);
                continue;
            }
            t.infos.put(parts[0].trim(), new Info(TokenCookie.unescape(parts[1].trim()), TokenCookie.unescape(parts[2].trim())));
        }
        return t;
    }

    public boolean remove(String repoId) {
        return this.infos.remove(repoId) != null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String delim = "";
        for (Map.Entry<String, Info> e : this.infos.entrySet()) {
            b.append(delim);
            if (e.getKey().length() > 0) {
                b.append(e.getKey()).append(":");
            }
            b.append(e.getValue());
            delim = ";";
        }
        return TokenCookie.escape(b.toString());
    }

    public static String getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name) || "".equals(cookie.getValue())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    @Deprecated
    public static void setCookie(HttpServletResponse response, String name, String value, int maxAge, String path) {
        TokenCookie.setCookie(response, name, value, maxAge, path, null, false, false);
    }

    public static void setCookie(HttpServletResponse response, String name, String value, int maxAge, String path, String domain, boolean isHttpOnly, boolean isSecure) {
        TokenCookie.setCookie(response, name, value, maxAge, path, domain, isHttpOnly, isSecure, TokenAuthenticationHandler.getSameSiteCookieAttribute());
    }

    public static void setCookie(HttpServletResponse response, String name, String value, int maxAge, String path, String domain, boolean isHttpOnly, boolean isSecure, String sameSiteCookieAttribute) {
        StringBuilder header = new StringBuilder();
        header.append(name).append("=").append(value);
        header.append("; Path=").append(path);
        if (isHttpOnly) {
            header.append("; HttpOnly");
        }
        if (domain != null) {
            header.append("; Domain=").append(domain);
        }
        if (maxAge >= 0) {
            header.append("; Max-Age=").append(maxAge);
        }
        if (isSecure) {
            header.append("; Secure");
        }
        if (sameSiteCookieAttribute != null) {
            header.append("; SameSite=").append(sameSiteCookieAttribute);
        }
        response.addHeader("Set-Cookie", header.toString());
    }

    private static String escape(String string) {
        try {
            BitSet validChars = URISaveEx;
            byte[] bytes = string.getBytes("utf-8");
            StringBuffer out = new StringBuffer(bytes.length);
            for (int i = 0; i < bytes.length; ++i) {
                int c = bytes[i] & 0xFF;
                if (validChars.get(c) && c != 37) {
                    out.append((char)c);
                    continue;
                }
                out.append('%');
                out.append(hexTable[c >> 4 & 0xF]);
                out.append(hexTable[c & 0xF]);
            }
            return out.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.toString());
        }
    }

    private static String unescape(String string) {
        int pos;
        ByteArrayOutputStream out = new ByteArrayOutputStream(string.length() * 2);
        int lastPos = 0;
        while ((pos = string.indexOf(37, lastPos)) >= 0) {
            try {
                out.write(string.substring(lastPos, pos).getBytes("utf-8"));
            }
            catch (IOException e) {
                throw new InternalError(e.toString());
            }
            lastPos = pos + 3;
            if (lastPos > string.length()) continue;
            try {
                out.write(Integer.parseInt(string.substring(pos + 1, lastPos), 16));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException();
            }
        }
        if (lastPos >= 0 && lastPos <= string.length()) {
            try {
                out.write(string.substring(lastPos).getBytes("utf-8"));
            }
            catch (IOException e) {
                throw new InternalError(e.toString());
            }
        }
        try {
            return new String(out.toByteArray(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.toString());
        }
    }

    private static String[] explode(String str, int ch, boolean respectEmpty) {
        int pos;
        Vector<String> strings = new Vector<String>();
        int lastpos = 0;
        while ((pos = str.indexOf(ch, lastpos)) >= 0) {
            if (pos - lastpos > 0 || respectEmpty) {
                strings.add(str.substring(lastpos, pos));
            }
            lastpos = pos + 1;
        }
        if (lastpos < str.length()) {
            strings.add(str.substring(lastpos));
        } else if (respectEmpty && lastpos == str.length()) {
            strings.add("");
        }
        return strings.toArray(new String[strings.size()]);
    }

    static {
        int i;
        log = LoggerFactory.getLogger(TokenCookie.class);
        ATTR_NAME = TokenCookie.class.getName();
        URISaveEx = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            URISaveEx.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            URISaveEx.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            URISaveEx.set(i);
        }
        URISaveEx.set(45);
        URISaveEx.set(95);
        URISaveEx.set(46);
        URISaveEx.set(33);
        URISaveEx.set(126);
        URISaveEx.set(42);
        URISaveEx.set(39);
        URISaveEx.set(40);
        URISaveEx.set(41);
        URISaveEx.set(47);
        hexTable = "0123456789abcdef".toCharArray();
    }

    public static class Info {
        public static final Info INVALID = new Info(null, null);
        public static final String ATTR_NAME = Info.class.getName();
        public final String token;
        public final String workspace;

        public Info(String token, String workspace) {
            this.workspace = workspace;
            this.token = token;
        }

        public boolean isValid() {
            return this.token != null && this.token.length() > 0;
        }

        public String toString() {
            if (this.token == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(TokenCookie.escape(this.token)).append(":");
            sb.append(TokenCookie.escape(this.workspace));
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Info info = (Info)o;
            if (this.token != null ? !this.token.equals(info.token) : info.token != null) {
                return false;
            }
            return !(this.workspace != null ? !this.workspace.equals(info.workspace) : info.workspace != null);
        }

        public int hashCode() {
            int result = this.token != null ? this.token.hashCode() : 0;
            result = 31 * result + (this.workspace != null ? this.workspace.hashCode() : 0);
            return result;
        }
    }
}

