/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.IOException;
import javax.management.openmbean.TabularData;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.jmx.Description;
import org.apache.jackrabbit.oak.api.jmx.Name;

public interface LuceneIndexMBean {
    public static final String TYPE = "LuceneIndex";

    public TabularData getIndexStats() throws IOException;

    public TabularData getBadIndexStats();

    public TabularData getBadPersistedIndexStats();

    public boolean isFailing();

    @Description(value="Determines the set of index paths upto given maxLevel. This can be used to determine the value for[includedPaths]. For this to work you should have [evaluatePathRestrictions] set to true in your index definition")
    public String[] getIndexedPaths(@Description(value="Index path for which stats are to be determined") @Name(value="indexPath") String var1, @Name(value="maxLevel") @Description(value="Maximum depth to examine. E.g. 5. Stats calculation would break out after this limit") int var2, @Description(value="Maximum number of unique paths to examine. E.g. 100. Stats calculation would break out after this limit") @Name(value="maxPathCount") int var3) throws IOException;

    @Description(value="Retrieves the fields, and number of documents for each field, for an index. This allows to investigate what is stored in the index.")
    public String[] getFieldInfo(@Name(value="indexPath") @Description(value="The index path (empty for all indexes)") String var1) throws IOException;

    @Description(value="Retrieves the terms, and number of documents for each term, for an index. This allows to closely investigate what is stored in the index.")
    public String[] getFieldTermsInfo(@Name(value="indexPath") @Description(value="The index path (empty for all indexes)") String var1, @Name(value="field") @Description(value="The field name (empty for all fields)") String var2, @Name(value="max") @Description(value="The maximum number of entries to return (e.g. 100)") int var3) throws IOException;

    @Description(value="Retrieves the number of documents for a specific term, for an index. This allows to closely investigate what is stored in the index.")
    public String[] getFieldTermInfo(@Name(value="indexPath") @Description(value="The index path (empty for all indexes)") String var1, @Name(value="field") @Description(value="The field name (empty for all fields)") String var2, @Name(value="term") @Description(value="The term") String var3) throws IOException;

    @Description(value="Returns the stored index definition for index at given path in string form")
    public String getStoredIndexDefinition(@Name(value="indexPath") String var1);

    @Description(value="Returns the diff of index definition for index at given path from the stored index definition in string form")
    public String diffStoredIndexDefinition(@Name(value="indexPath") String var1);

    @Description(value="Performs consistency check on given index")
    public String checkConsistency(@Name(value="indexPath") String var1, @Name(value="fullCheck") @Description(value="If set to true a full check would be performed which can be slow as it reads all index files. If set to false a quick check is performed to check if all blobs referred in index files are present in BlobStore") boolean var2) throws IOException;

    @Description(value="Performs consistency check for all Lucene indexes and reports in simple format")
    public String[] checkAndReportConsistencyOfAllIndexes(@Name(value="fullCheck") @Description(value="If set to true a full check would be performed which can be slow as it reads all index files. If set to false a quick check is performed to check if all blobs referred in index files are present in BlobStore") boolean var1) throws IOException;

    @Description(value="Performs consistency check for all Lucene indexes and reports true if all indexes are found to be valid. False if any one of them was not found to be valid")
    public boolean checkConsistencyOfAllIndexes(@Name(value="fullCheck") @Description(value="If set to true a full check would be performed which can be slow as it reads all index files. If set to false a quick check is performed to check if all blobs referred in index files are present in BlobStore") boolean var1) throws IOException;

    @Description(value="Performs any possible cleanup of the hybrid property indexes")
    public String performPropertyIndexCleanup() throws CommitFailedException;

    @Description(value="Performs cleanup of property indexes")
    public String performPropertyIndexCleanup(@Name(value="paths") @Description(value="The list of paths (comma separated). Must be hidden nodes") String var1, @Name(value="batchSize") @Description(value="The batch size, e.g. 1024") int var2, @Name(value="sleepPerBatch") @Description(value="The number of milliseconds to sleep per batch") int var3, @Name(value="maxRemoveCount") @Description(value="The maximum number of nodes to remove per path, e.g. 1000000") int var4) throws CommitFailedException;

    @Description(value="Fetches hybrid property index info as json for index at given path")
    public String getHybridIndexInfo(@Name(value="indexPath") String var1);

    @Description(value="Fetches index size for index at given path")
    public String getSize(@Name(value="indexPath") String var1) throws IOException;

    @Description(value="Fetches current number of docs for index at given path")
    public String getDocCount(@Name(value="indexPath") String var1) throws IOException;
}

