/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.request;

import java.util.HashMap;
import java.util.StringTokenizer;

public class RequestDispatcherOptions
extends HashMap<String, String> {
    private static final long serialVersionUID = -9081782403304877746L;
    public static final String OPT_FORCE_RESOURCE_TYPE = "forceResourceType";
    public static final String OPT_REPLACE_SELECTORS = "replaceSelectors";
    public static final String OPT_ADD_SELECTORS = "addSelectors";
    public static final String OPT_REPLACE_SUFFIX = "replaceSuffix";

    public RequestDispatcherOptions() {
    }

    public RequestDispatcherOptions(String options) {
        if (options != null && options.length() > 0) {
            if (options.indexOf(44) < 0 && options.indexOf(61) < 0) {
                this.setForceResourceType(options.trim());
            } else {
                StringTokenizer tk = new StringTokenizer(options, ",");
                while (tk.hasMoreTokens()) {
                    String entry = tk.nextToken();
                    int equals = entry.indexOf(61);
                    if (equals <= 0 || equals >= entry.length() - 1) continue;
                    this.put(entry.substring(0, equals).trim(), entry.substring(equals + 1).trim());
                }
            }
        }
    }

    public void setForceResourceType(String resourceType) {
        if (resourceType != null) {
            this.put(OPT_FORCE_RESOURCE_TYPE, resourceType);
        }
    }

    public String getForceResourceType() {
        return (String)this.get(OPT_FORCE_RESOURCE_TYPE);
    }

    public void setAddSelectors(String additionalSelectors) {
        if (additionalSelectors != null) {
            this.put(OPT_ADD_SELECTORS, additionalSelectors);
        }
    }

    public String getAddSelectors() {
        return (String)this.get(OPT_ADD_SELECTORS);
    }

    public void setReplaceSelectors(String replaceSelectors) {
        if (replaceSelectors != null) {
            this.put(OPT_REPLACE_SELECTORS, replaceSelectors);
        }
    }

    public String getReplaceSelectors() {
        return (String)this.get(OPT_REPLACE_SELECTORS);
    }

    public void setReplaceSuffix(String replaceSuffix) {
        if (replaceSuffix != null) {
            this.put(OPT_REPLACE_SUFFIX, replaceSuffix);
        }
    }

    public String getReplaceSuffix() {
        return (String)this.get(OPT_REPLACE_SUFFIX);
    }
}

