/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.repoinit.parser.impl.ParseException;

public class PropertyLine {
    private final String name;
    private final PropertyType propertyType;
    private final List<Object> values;
    private boolean isDefault = false;

    public PropertyLine(String name, String typeString, List<String> values, boolean isDefault) throws ParseException {
        this.name = name;
        this.propertyType = typeString == null ? PropertyType.String : PropertyLine.parseType(typeString);
        this.values = PropertyLine.parseList(this.propertyType, values);
        this.isDefault = isDefault;
    }

    private static PropertyType parseType(String type) throws ParseException {
        try {
            return PropertyType.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Invalid property type:" + type);
        }
    }

    private static List<Object> parseList(PropertyType type, List<String> values) throws ParseException {
        if (values == null) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (String val : values) {
            result.add(PropertyLine.parseValue(type, val));
        }
        return result;
    }

    private static Object parseValue(PropertyType type, String value) throws ParseException {
        if (value == null) {
            throw new ParseException("Null value for type " + (Object)((Object)type));
        }
        if (type == PropertyType.String) {
            return value;
        }
        if (type == PropertyType.Long) {
            return Long.valueOf(value);
        }
        if (type == PropertyType.Double) {
            return Double.valueOf(value);
        }
        if (type == PropertyType.Date) {
            return PropertyLine.parseDate(value);
        }
        if (type == PropertyType.Boolean) {
            return Boolean.valueOf(value);
        }
        throw new ParseException("Invalid type " + (Object)((Object)type));
    }

    private static Calendar parseDate(String dateStr) throws ParseException {
        Calendar result = ISO8601.parse(dateStr);
        if (result == null) {
            throw new ParseException("Invalid ISO8601 date: " + dateStr);
        }
        return result;
    }

    public String getPropertyName() {
        return this.name;
    }

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    public List<Object> getPropertyValues() {
        return Collections.unmodifiableList(this.values);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" ");
        if (this.isDefault()) {
            sb.append("default ");
        }
        sb.append(this.name);
        sb.append("{");
        sb.append(this.propertyType.toString());
        sb.append("}=[");
        String sep = "";
        for (Object value : this.values) {
            sb.append(sep);
            sep = ", ";
            sb.append("{").append(value.getClass().getSimpleName()).append("}");
            if (value instanceof Calendar) {
                sb.append(ISO8601.format((Calendar)value));
                continue;
            }
            sb.append(value.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum PropertyType {
        String,
        Long,
        Double,
        Date,
        Boolean;

    }
}

