/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.export.json;

import java.util.Map;

import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

/**
 * The {@code SlingModelFilter} can be used by {@link ComponentExporter}s in order to filter {@link Resource}s and properties that are
 * exported.
 */
@ProviderType
public interface SlingModelFilter {

    /**
     * Returns the filtered properties to be exported.
     *
     * @param properties The properties to be filtered.
     * @return Returns the filtered properties to be exported.
     */
    Map<String, Object> filterProperties(Map<String, Object> properties);

    /**
     * Returns the filtered child {@link Resource}s to be exported.
     *
     * @param childResources The child resources to be filtered.
     * @return Returns the filtered child {@link Resource}s to be exported.
     */
    Iterable<Resource> filterChildResources(Iterable<Resource> childResources);

}
