/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.resourcestatus;

import org.apache.sling.api.resource.Resource;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;

/**
 * A {@code ResourceStatusProvider} provides {@link ResourceStatus}es of a certain status type
 * about {@link Resource}s.
 */
public interface ResourceStatusProvider {

    /**
     * Returns the type of statuses that are provided by this provider. The status type defines
     * the module or feature the status originates from. The statuses returned by
     * {@link #getStatuses(Resource)} must be of the this status type.
     *
     * @return the type of the statuses provided by this provider
     * @see ResourceStatus#getType()
     */
    @Nonnull
    String getType();

    /**
     * Returns a list of {@link ResourceStatus}es for a given {@link Resource}. The returned
     * statuses must match the status type returned by {@link #getType()} and must
     * not leak any information which the {@code resource}'s underlying resource provider
     * is not privileged to access.
     *
     * @param resource a resource
     * @return a list of statuses
     * @see ResourceStatus
     */
    @Nullable
    List<ResourceStatus> getStatuses(Resource resource);

}
