/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.api;

import java.awt.image.BufferedImage;
import java.io.InputStream;

/**
 * A context is given to a {@link FormatHandler} in order to identify the chain of handlers and the asset being
 * generated.
 *
 * @author dpfister
 */
public interface Context {

    /**
     * Add an exception that occurred while processing an asset.
     *
     * @param e exception to add
     */
    public void addException(ProcessorException e);

    /**
     * Add thumbnail image.
     *
     * @param image buffered image
     */
    public void addThumbnail(BufferedImage image);

    /**
     * Add metadata.
     *
     * @param metadata metadata
     */
    public void addMetadata(InputStream metadata);
}
