/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2018 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.api.s7dam.utils;

import javax.jcr.RepositoryException;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

import com.day.cq.dynamicmedia.api.NotNullApi;

/**
 * This utility interface provides miscellaneous functions which are used to construct a VideoViewer object
 */

@ProviderType
@NotNullApi
public interface VideoViewerUtil {

    /**
     * Constructs the preview url for the video asset {@code resource}
     *
     * @param resource Video asset sling resource
     *
     * @return Preview url for video asset {@code resource}. Returns null if preview url can't be found.
     */
    @Nullable
    String getPreviewUrlForVideoAssetResource(Resource resource);

    /**
     * Retrieves the value of {@code dam:scene7FileAvs} property or {@code  dam:scene7File} property of
     * the video asset sling {@code resource}.
     *
     * @param resource Video asset Sling resource. Should be adaptable to {@link com.day.cq.dam.api.Asset}.
     *
     * @return
     * <p>The value of {@code dam:scene7FileAvs} property from the video asset metadata.</p>
     * <p>If {@code dam:scene7FileAvs} property is not found, returns the value of {@code dam:scene7File} property.</p>
     * <p>Returns null if the {@code resource} is not adaptable to {@link com.day.cq.dam.api.Asset}.</p>
     *
     * @throws IllegalArgumentException If {@code resource} is null.
     */
    @Nullable
    String getS7FileHandleForVideoAssetResource(Resource resource);

    /**
     *
     * Constructs the Scene7 viewers' parent node path from viewer presets config in the JCR Repository.
     *
     * @param resourceResolver ResourceResolver object for accessing the JCR repository.
     *
     * @return The absolute JCR path to the Scene7 viewers parent node.
     *
     * @throws RepositoryException If the methods fails to read the repository.
     * @throws IllegalArgumentException If {@code resourceResolver} is null.
     */

    String getS7ViewerPath(ResourceResolver resourceResolver) throws RepositoryException;
}
