/**
 * 
 */
package com.adobe.fontengine.fontmanagement;

import java.util.ArrayList;
import java.util.Iterator;

import com.adobe.fontengine.inlineformatting.css20.CSS20FontDatabase;
import com.adobe.internal.util.ArrayListStack;

/**
 * @author stuart
 *
 */
public abstract class FontSetStack
{
	private ArrayListStack /*<ArrayList>*/ fontStack = new ArrayListStack();
	
	/**
	 * 
	 */
	public FontSetStack()
	{
		// TODO Auto-generated constructor stub
	}

	public FontSetStack(CSS20FontDatabase original)
	{
		// do nothing special
		// this will be equivalent to flattening the font set
	}

	public void pushFontSet()
	{
		ArrayList /*<FontProxy>*/ fontList = new ArrayList();
		this.fontStack.push(fontList);
	}
	
	public void popFontSet()
	{
		ArrayList fontList = (ArrayList) this.fontStack.pop();
		if (fontList == null)
		{
			return;
		}
		Iterator iter = fontList.iterator();
		while (iter.hasNext())
		{
			FontProxy fontProxy = (FontProxy) iter.next();
			removeFontProxy(fontProxy);
		}		
	}
	
	public void restoreOriginalFontSet()
	{
		while (this.fontStack.size() > 0)
		{
			this.popFontSet();
		}
	}
	
	public void flattenFontSet()
	{
		this.fontStack.clear();
	}

	protected void fontAdded(FontProxy fontProxy)
	{
		if (this.fontStack.empty())
		{
			return;
		}
		ArrayList fontList = (ArrayList) this.fontStack.peek();
		if (fontList == null)
		{
			return;
		}
		fontList.add(fontProxy);
	}
	
//	protected void fontRemoved(Font font)
//	{
//		
//	}
	
	abstract protected void removeFontProxy(FontProxy fontProxy);	
}
