/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.oauth.server;

/**
 * Extended Scope interface for scopes that define required privileges on their content paths.  The privileges defined
 * in the scope will be created by the OAuth Server using the oauthservice user.  It is the responsibility of the scope
 * developer to ensure that oauthservice has the necessary privileges to do this.
 */
public interface ScopeWithPrivileges extends Scope {
    /**
     * Get the privileges associated with the scope.
     * @return A String[] of Privilege names.
     */
    public String[] getPrivileges();
}
