/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.references;

import java.util.List;

import org.apache.sling.api.resource.Resource;

import org.osgi.annotation.versioning.ProviderType;

/**
 * A <code>ReferenceList</code> provides a collection of {@link Reference}s specific to a {@link Resource}.
 * The type of references provided is dependent on the available {@link ReferenceProvider}s registered in the system.
 * A <code>ReferenceList</code> can be retrieved by adapting a resource:
 * <code>resource.adaptTo(ReferenceList.class)</code>.
 * Any resource can be adapted. Whether references are provided for a resource is decided by the references providers.
 *
 * @since 1.0
 */
@ProviderType
public interface ReferenceList extends List<Reference> {

    /**
     * Returns the {@link Resource} for which this reference list was created.
     *
     * @return The {@link Resource}.
     */
    Resource getResource();

    /**
     * Returns a {@link List} of all {@link Reference}s available for the resource backing the references list,
     * filtered by an array of {@link String}s corresponding to references types.
     * If no items are found, an empty list is returned.
     *
     * Caution:
     * At this stage, the reference list is already created and retrieved references for all the reference types.
     * Use com.adobe.granite.references.ReferenceAggregator#createReferenceList(org.apache.sling.api.resource.Resource, java.lang.String...) to process filtering even before the reference search
     *
     * @return A filtered {@link List} of {@link Reference}s, or an empty collection if no references were found.
     */
    List<Reference> subList(String... types);

}
