/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.adobe.granite.translation.connector.msft.core.ui.models;

import com.adobe.granite.translation.connector.msft.core.ui.utils.MicrosoftCloudServiceUtils;
import org.apache.jackrabbit.JcrConstants;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.PostConstruct;
import java.util.Map;

@Model(adaptables = SlingHttpServletRequest.class)
public class MicrosoftTranslationConnector {

    private static final Logger logger = LoggerFactory.getLogger(MicrosoftTranslationConnector.class);

    @Self
    private SlingHttpServletRequest request;

    private Resource microsoftConfigResource;
    private ResourceResolver resourceResolver;

    private static final String SERVICE_LABEL = "servicelabel";
    private static final String SERVICE_ATTRIBUTION = "serviceattribution";
    private static final String WORKSPACE_ID = "workspaceId";
    private static final String SUBSCRIPTION_KEY = "subscriptionkey";
    private static final String DESCRIPTION = "cq:description";
    private static final String EXTENDED_DESCRIPTION = "descriptionExtended";

    private static String microsoftConfigPath;

    @PostConstruct
    public void postConstruct()  throws Exception {
        microsoftConfigPath = request.getRequestPathInfo().getSuffix();
        resourceResolver = request.getResourceResolver();
        microsoftConfigResource = resourceResolver.getResource(microsoftConfigPath);
    }

    public boolean isOverLayRequired() {
        if (microsoftConfigPath.startsWith(MicrosoftCloudServiceUtils.CLOUDSERVICE_LIBS_PATH)) {
            return true;
        }
        return false;
    }

    public Map<String, String> getHiddenFields() {
        return MicrosoftCloudServiceUtils.getHiddenFields(request);
    }

    public String getConfOverlayPath() {
        return MicrosoftCloudServiceUtils.getConfOverlayPath(microsoftConfigPath) + '/' + JcrConstants.JCR_CONTENT;
    }

    public String getServiceLabel() {
        return MicrosoftCloudServiceUtils.getStringPropertyFromContent(microsoftConfigResource ,SERVICE_LABEL);
    }

    public String getServiceAttribution() {
        return MicrosoftCloudServiceUtils.getStringPropertyFromContent(microsoftConfigResource ,SERVICE_ATTRIBUTION);
    }

    public String getWorkspaceId() {
        return MicrosoftCloudServiceUtils.getStringPropertyFromContent(microsoftConfigResource ,WORKSPACE_ID);
    }

    public String getSubscriptionKey() {
        return MicrosoftCloudServiceUtils.getStringPropertyFromContent(microsoftConfigResource ,SUBSCRIPTION_KEY);
    }

    public String getDescription() {
        return MicrosoftCloudServiceUtils.getConnectorProperty(resourceResolver, microsoftConfigPath, DESCRIPTION);
    }

    public String getExtendedDescription() {
        return MicrosoftCloudServiceUtils.getConnectorProperty(resourceResolver, microsoftConfigPath,
                EXTENDED_DESCRIPTION);
    }

    public boolean getConnectEnabled() {
        String connectEnabled = MicrosoftCloudServiceUtils.getConnectorProperty(resourceResolver, microsoftConfigPath
                , SUBSCRIPTION_KEY);
        return "".equals(connectEnabled);
    }
}
