/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.launcher;

import com.adobe.granite.workflow.WorkflowException;

import java.util.Iterator;

/**
 * The <code>WorkflowLauncher</code> starts workflow depending on:
 * <ul>
 *  <li>jcr event
 *  <li>path (regular expression)
 *  <li>nodetype
 * </ul>
 */
public interface WorkflowLauncher {

    /**
     * Add new launcher configuration entry
     * @param entry  launcher config entry
     * @throws WorkflowException thrown in case config entry could not be added
     */
    void addConfigEntry(ConfigEntry entry) throws WorkflowException;

    /**
     * Remove launcher config entry
     * @param id config entry id
     * @throws WorkflowException thrown in case config entry could not be removed
     */
    void removeConfigEntry(String id) throws WorkflowException;

    /**
     * Get list of all config entries
     * @return list of all config entries
     * @throws WorkflowException thrown in case config entries could not be retrieved
     */
    Iterator<ConfigEntry> getConfigEntries() throws WorkflowException;

    /**
     * Edit existing config entry
     * @param id id if existing config entry
     * @param configEntry modified config entry
     * @throws WorkflowException thrown in case config entry could not be edited
     */
    void editConfigEntry(String id, ConfigEntry configEntry) throws WorkflowException;
}
