/*
 * File: ASNameTrie.java
 * ************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.internal.pdftoolkit.core.types;

/**
 * Trie to store ASName objects based on their bytes for fast retrieval 
 * @author hraghav
 */
class ASNameTrie 
{
	private ASNameTrie[] childNodes = new ASNameTrie[256];
	private ASName name;
	
	ASNameTrie() 
	{
		name = null;
	}
	
	private ASNameTrie addChild(ASNameTrie child, byte ch)
	{
		childNodes[ch + 128] = child;
		return child;
	}
	
	private  ASNameTrie getNode(byte ch)
	{
		return childNodes[ch + 128];		
	}
	
	private void setName(ASName name)
	{
		this.name = name;		
	}
	
	private ASName getName()
	{
		return name;
	}
	
	void add(ASName name)
	{
		byte[] nameBytes = name.getBytes();
		add(name, nameBytes, 0, nameBytes.length);
	}
	
	private void add(ASName name, byte[] nameBytes, int start, int end)
	{
		if(start >= end)
		{
			return;
		}
		
		byte ch =  nameBytes[start];
		ASNameTrie n = getNode(ch);
		
		if(n == null)
		{
			// No such node exists
			ASNameTrie child = new ASNameTrie();
			child = addChild(child, ch);
			if(child != null)
			{
				if(start + 1 == end)
				{
					// last byte
					child.setName(name);
				}
				else
				{
					child.add(name, nameBytes, start + 1, end);
				}
			}
		}
		else
		{
			n.add(name, nameBytes, start + 1, end);
		}
		return;		
	}
	
	

	public ASName get(byte[] nameBytes, int start, int end)
	{
		if(start >= end)
		{
			return null;
		}
		
		byte byteToLook = nameBytes[start];
		
		ASNameTrie node = getNode(byteToLook);
		if(node != null)
		{
			if(start + 1 == end)
			{
				return node.getName();
			}
			else
			{
				return node.get(nameBytes, start + 1, end);
			}
		}
		return null;
	}

}
