/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2013 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.cq.dam.api.handler.xmp;
import java.util.Set;

import com.day.cq.dam.api.Rendition;

import aQute.bnd.annotation.ProviderType;
/**
 * The <code>XMPWriteBackOptions</code> interface defines the options for writing XMP metadata information to a
 * binary.
 */

@ProviderType
public interface XMPWriteBackOptions {
    /**
     * Returns whether a version needs to be created or not for an asset on each writeback    
     * @return createVersion 
     * */
    boolean isCreateVersion();
    
    /**
     * Sets the value whether version is to be created for an asset on each writeback
     * @param createVersion if true then create versions of the asset on each writeback   
     * */
    void createVersion(boolean createVersion);
    
    /**
     * Returns the set of renditions of an Asset for which XMP meta writeback has to be done    
     * @return renditions
     * */
    Set<Rendition> getRenditions();
        
    /**
     * Sets the renditions for which XMP meta writeback has to be done      
     * @param renditions asset's renditions for which XMP meta writeback has to be done
     * */
    void setRenditions(Set <Rendition> renditions);

    /**
     * Allows XMP Writeback to update {@link DamConstants.PN_VERSION_CREATOR} of the asset
     * Applicable only when {@link isCreateVersion} returns true
     * @param userId principal of the user that should be updated as creator of the version
     * */
    void setVersionCreator(String userId);

    /**
     * XMP Writeback updates {@link DamConstants.PN_VERSION_CREATOR} of the asset as returned
     * by this API. Applicable only when {@link isCreateVersion} returns true
     * @return userId principal of the user that should be updated as creator of the version
     *                or empty string if none was set using {@link setVersionCreator}
     * */
    String getVersionCreator();
}