/*
 * ***********************************************************************
 *
 *  ADOBE CONFIDENTIAL
 *  ___________________
 *
 *   Copyright 2012 Adobe Systems Incorporated
 *   All Rights Reserved.
 *
 *  NOTICE:  All information contained herein is, and remains
 *  the property of Adobe Systems Incorporated and its suppliers,
 *  if any.  The intellectual and technical concepts contained
 *  herein are proprietary to Adobe Systems Incorporated and its
 *  suppliers and are protected by trade secret or copyright law.
 *  Dissemination of this information or reproduction of this material
 *  is strictly forbidden unless prior written permission is obtained
 *  from Adobe Systems Incorporated.
 * ************************************************************************
 */

package com.day.cq.mcm.emailprovider.types;

/**
 * Defines interface for subscriber(lead) to the external email provider. The getter and setter methods for subscriber name and id are inherited from NamedType.
 */
public interface Subscriber extends NamedType {
    /**
     * Status param that can be used as custom parameter to specify subscriber status.
     */
    public static final String STATUS_PARAM = "status";

    /**
     * Get the subscriber email address.
     * @return The email address of the subscriber.
     */
    public String getEmail();

    /**
     * Set the subscriber email address.
     * @param email The email address of the subscriber.
     */
    public void setEmail(String email);

    /**
     * Get the first name of the subscriber.
     * @return The subscriber first name.
     */
    public String getFirstName();

    /**
     * Set the first name of the subscriber.
     * @param firstName The first name of the subscriber.
     */
    public void setFirstName(String firstName);

    /**
     * Get the last name of the subscriber.
     * @return The subscriber last name.
     */
    public String getLastName();

    /**
     * Set the last name of the subsciber.
     * @param lastName The subscriber last name.
     */
    public void setLastName(String lastName);

}
