/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.personalization;

import java.util.Set;

import org.apache.sling.api.resource.Resource;

import com.day.cq.personalization.impl.util.PersonalizationConstants;

/**
 * The AreaService defines an interface to retrieve areas for certain types
 * of resources.
 */
public interface AreaService {

    /**
     * Returns a {@code Set} of area resources for the specified
     * {@code brandResource} or an empty {@code Set} if no areas where found
     * for that brand.
     * 
     * @param brandResource Resource representing a brand.
     * @return Area resource for specified {@code brandResource} or an empty
     *         set.
     */
    Set<Resource> getAreasForBrand(Resource brandResource);

    /**
     * Returns a {@code Set} of area resources for the specified
     * {@code pageResource} or an empty {@code Set} if no areas where
     * referenced via property {@link PersonalizationConstants#PN_TARGET_AMBITS}
     * on that page.
     * 
     * @param pageResource Resource representing a page.
     * @return Area resources for specified {@code pageResource} or an empty
     *         set.
     */
    Set<Resource> getAreasForPage(Resource pageResource);

}
