/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow;

/**
 * <code>WorkflowException</code> is the base class for all workflow related
 * exceptions that can occur during execution of workflows and according
 * activities.
 *
 */
public class WorkflowException extends Exception {
	/**
	 * Generated serial version UID.
	 */
	private static final long serialVersionUID = 3126765556125618406L;

	/**
	 * Constructs a new <code>WorkflowException</code> with the specified
	 * detail message. The cause is not initialized, and may subsequently be
	 * initialized by a call to {@link #initCause}.
	 * 
	 * @param message
	 *            The detail message. The detail message is saved for later
	 *            retrieval by the {@link #getMessage()} method.
	 */
	public WorkflowException(String message) {
		super(message);
	}

	/**
	 * Constructs a new <code>WorkflowException</code> with the specified
	 * cause and a detail message of
	 * <tt>(cause==null ? null : cause.toString())</tt> (which typically
	 * contains the class and detail message of <tt>cause</tt>). This
	 * constructor is useful for <code>WorkflowException</code> that are
	 * wrappers for other <code>{@link Throwable}</code>s.
	 * 
	 * @param cause
	 *            The cause (which is saved for later retrieval by the
	 *            {@link #getCause()} method). (A <tt>null</tt> value is
	 *            permitted, and indicates that the cause is nonexistent or
	 *            unknown.)
	 */
	public WorkflowException(Throwable cause) {
		super(cause);
	}

	/**
	 * Constructs a new <code>WorkflowException</code> with the specified
	 * detail message and cause.
	 * 
	 * @param message
	 *            The detail message (which is saved for later retrieval by the
	 *            {@link #getMessage()} method).
	 * @param cause
	 *            The cause (which is saved for later retrieval by the
	 *            {@link #getCause()} method). (A <tt>null</tt> value is
	 *            permitted, and indicates that the cause is nonexistent or
	 *            unknown.)
	 */
	public WorkflowException(String message, Throwable cause) {
		super(message, cause);
	}
}
