/*
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */
package com.day.util.diff;

/**
 * Specifies a range in a document
 */
public class Range {

    /**
     * the document this range points to
     */
    public final Document doc;

    /**
     * the low line of this range
     */
    public final int low;

    /**
     * the high line of this range. actually points to the line after the one
     * included in this range.
     */
    public final int high;

    /**
     * Creates a new range
     * @param doc the document
     * @param low the low line
     * @param high the high line
     */
    public Range(Document doc, int low, int high) {
        assert low >= 0;
        assert high >= low;
        this.doc = doc;
        this.low = low;
        this.high = high;
    }

    /**
     * Returns the length of this range
     * @return the length.
     */
    public int len() {
        return high - low;
    }

    /**
     * Returns a debug string
     * @return a debug string
     */
    public String toString() {
        return low + "-" + high;
    }

    /**
     * Returns a string suitable for inclusion in a diff output (line number is
     * incremented by one).
     * @return a string for output
     */
    public String toRangeString() {
        if (len() == 1) {
            return String.valueOf(low+1);
        } else {
            return (low + 1) + "," + len();
        }
    }
}