/*
*
*	File: RemoveSpacesAndUppercaseNormalizer.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/

package com.adobe.fontengine.inlineformatting.css20;

/**
 * RemoveSpacesAndUppercaseNormalizer
 */
final public class RemoveSpacesAndUppercaseFamilyNameNormalizer implements FamilyNameNormalizer
{
    static final long serialVersionUID = 1;

    /**
     * This <code>FamilyNameNormalizer</code> first removes all characters in the Unicode General Category 'Z'.
     * It then converts them to uppercase using the current default locale.
     */
    public RemoveSpacesAndUppercaseFamilyNameNormalizer()
    {
        super();
    }

    public String normalize(String familyName)
    {
        String normalized = familyName.replaceAll("\\p{Z}", "");
        return normalized.toUpperCase();
    }

}
