/*
*
*	File: LookupsCache.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/
package com.adobe.fontengine.inlineformatting.infontformatting;


import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.opentype.LookupTable;

final class LookupsCache {

  static final WeakHashMap /*<LookupTable, ?>*/ lookupTableMap = new WeakHashMap /*<LookupTable, ?>*/ ();
  
  static int[][] resolveFeatureTag (LookupTable table, int scriptTag,
                                    int langTag, int[] featureTags)
      throws InvalidFontException {
      
    Map lookupTableEntry = (Map) lookupTableMap.get (table);
    if (lookupTableEntry == null) {
      lookupTableEntry = new HashMap ();
      lookupTableMap.put (table, lookupTableEntry); }
    
    Map scriptEntry = (Map) lookupTableEntry.get (new Integer (scriptTag));
    if (scriptEntry == null) {
      scriptEntry = new HashMap ();
      lookupTableEntry.put (new Integer (scriptTag), scriptEntry); }
      
    int[][] lookups = (int[][]) scriptEntry.get (new Integer (langTag));
    if (lookups == null) {
      lookups = table.resolveFeatureTag (scriptTag, langTag, featureTags);
      scriptEntry.put (new Integer (langTag), lookups); }
           
    return lookups;
  }
}
