/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2014 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.translation.api;

//
/**
 * The TranslationResult is returned from all translation calls. It contains the translated string as well as other
 * data related to the translation call. It is possible some of the values returned from a service will be NULL but
 * the TranslationResult object it self will never return as NULL.
 */
public interface TranslationResult {

    /**
     * Gets the translation.
     * @return The translation response from the Machine Translation engine
     */
    String getTranslation();

    /**
     * Gets the source language.
     * @return The original source language. If this was not specified during the translation call it is determined by
     *         leveraging the Translation Detection functionality
     */
    String getSourceLanguage();

    /**
     * Gets the target language.
     * @return The target language. If this was not specified during the translation call it may be determined based
     *         on the Resource path, Resource locale, or locale of the user.
     */
    String getTargetLanguage();

    /**
     * Gets the content type.
     * @return The content type of the Source String and the Target String it was translated into.
     */
    TranslationConstants.ContentType getContentType();

    /**
     * Gets the category.
     * @return The content category. If this was not specified during the translation call it is defaulted to
     *         "general"
     */
    String getCategory();

    /**
     * Gets the source string.
     * @return The original source String that was translated.
     */
    String getSourceString();

    /**
     * Gets the rating.
     * @return The rating of the returned translation. If unknown this will return -999.
     */
    int getRating();

    /**
     * Gets the user id.
     * @return The ID corresponding to the user who edited the current translation. This might be the user who is
     *         currently editing a translation (@see TranslationService.storeTranslation) or the user who edited the
     *         currently returned translation (@see TranslationService.translateString). This field might be blank or
     *         null depending on the availability of this data.
     */
    String getUserId();

}