/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________
*
* Copyright 2015 Adobe
* All Rights Reserved.
*
* NOTICE: All information contained herein is, and remains
* the property of Adobe and its suppliers, if any. The intellectual
* and technical concepts contained herein are proprietary to Adobe
* and its suppliers and are protected by all applicable intellectual
* property laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe.
**************************************************************************/
package com.adobe.granite.ui.components.rendercondition;

import java.io.IOException;

import javax.annotation.Nonnull;
import javax.servlet.ServletException;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;

/**
 * The condition that returns {@code true} when all the sub conditions are
 * returning {@code false}; {@code true} otherwise.
 */
public class NotRenderCondition extends AbstractCompositeRenderCondition {
    public NotRenderCondition(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response,
            @Nonnull Resource resource) {
        super(request, response, resource);
    }

    @SuppressWarnings("null")
    @Override
    public boolean check() throws ServletException, IOException {
        for (Resource child : resource.getChildren()) {
            if (call(child).check()) {
                return false;
            }
        }

        return true;
    }
}
