/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2018 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package com.adobe.granite.workflow.model;

import org.osgi.annotation.versioning.ProviderType;

import java.util.Map;

/**
 * Interface for the schema information of the variables
 */
@ProviderType
public interface VariableTemplate {

    /**
     * Returns the variable's description
     * @return
     */
    String getDescription();

    /**
     * Sets the variable's description
     * @param description
     */
    void setDescription(String description);

    /**
     * Returns the type of the variable. It is in JAVA FQN format.
     * @return
     */
    String getType();

    /**
     * Sets the type of the variable.
     * @param type in java fqn format
     */
    void setType(String type);

    /**
     * Returns the name of the variable.
     * @return
     */
    String getName();

    /**
     * Sets the name of the variable.
     * It is expected to be the unique identifier of the variable.
     * @param name
     */
    void setName(String name);

    /**
     * Returns the subType of the variable. Relevant in case of Collection type variable.
     * @return
     */
    String getSubType();

    /**
     * Sets the subType of the variable. Relevant in case of Collection type variable.
     * @param subType
     */
    void setSubType(String subType);

    /**
     * Sets the default value of the variable.
     * @param defaultValue
     */
    void setDefaultValue (Object defaultValue);

    /**
     * Returns the default value of the variable
     * @return
     */
    Object getDefaultValue();

    /**
     * Returns {@link Map} of additional properties of the variable set during authoring.
     * @return
     */
    Map<String, String> getAdditionalProperties();

}
