/*
 * ***********************************************************************
 *
 *  ADOBE CONFIDENTIAL
 *  ___________________
 *
 *   Copyright 2012 Adobe Systems Incorporated
 *   All Rights Reserved.
 *
 *  NOTICE:  All information contained herein is, and remains
 *  the property of Adobe Systems Incorporated and its suppliers,
 *  if any.  The intellectual and technical concepts contained
 *  herein are proprietary to Adobe Systems Incorporated and its
 *  suppliers and are protected by trade secret or copyright law.
 *  Dissemination of this information or reproduction of this material
 *  is strictly forbidden unless prior written permission is obtained
 *  from Adobe Systems Incorporated.
 * ************************************************************************
 */

package com.day.cq.mcm.emailprovider.types;

public enum EmailServiceActions {
	GET_ACCOUNTS("getAccounts"),
	
	CONNECT("connect"),
	
	GET_FORM_FIELDS("getFormFields"),

	ADD_SUBSCRIBER("addToList"),
	
	DELETE_SUBSCRIBER("deleteFromList"),
	
	SEND_AUTO_RESPONDER("sendAutoResponderMail"),
	
	PUBLISH_EMAIL("publishEmail"),
	
	UPDATE_EMAIL("updateEmail"),

	SEND_EMAIL_TO_SUBSCRIBER("sendMailToSubscriber"),
	
	SEND_EMAIL_TO_SUBSCRIBER_LIST("sendMailToList"),
	
	GET_LISTS("getlist"),
	
	GET_PERSONALIZATION_INFO("getEmailTools"),
	
	GET_EMAILS("getemails"),
	
	GET_EMAIL_CLASSIFICATIONS("getemailclassifications"),
	
	CREATE_SUBSCRIPTION_LIST("createSubscriptionList"),
	
	DELETE_SUBSCRIPTION_LIST("deleteSubscriptionList"),
	
	GET_SUBSCRIBERS("getSubscribers");
	
	private final String operation;
	
	private EmailServiceActions(final String operation){
		this.operation = operation;
	}
	
	@Override
	public String toString(){
		return this.operation.toString();
	}
	
	public EmailServiceActions getAction(String action){
		for(EmailServiceActions act : EmailServiceActions.values())
		{
			if(act.toString().equals(action))
				return act;
		}
		return null;
	}
}
