/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.replication;

import java.util.List;

import javax.jcr.Node;
import javax.jcr.Property;

/**
 * Implementations of <code>ReplicationContentFilter</code> indicate to {@link ContentBuilder}s whether a given child
 * {@link Node} of a node being activated (e.g. a page or asset) shall be included in the replication content or not.
 * Implementations must be instantiated by their respective {@link ReplicationContentFilterFactory}, the factory
 * registering itself as an OSGi service.
 * For convenience a {@link ReplicationContentFilterChain} is provided to content builders
 * via the parameter {@link ContentBuilder#PARAMETER_CONTENT_FILER_CHAIN}.
 */
public interface ReplicationContentFilter {

    /**
     * Indicates whether the given {@link Node} is to be included in the content of the replication built by {@link
     * ContentBuilder}s.
     *
     * @param node The {@link Node} to check.
     * @return <code>true</code> if this node may be included in the replication content.
     */
    boolean accepts(Node node);

    /**
     * Indicates whether the given {@link Property} is to be included in the content of the replication built by {@link
     * ContentBuilder}s.
     *
     * @param property The {@link Property} to check.
     * @return <code>true</code> if this property may be included in the replication content.
     */
    boolean accepts(Property property);

    /**
     * Indicates whether the {@link ContentBuilder}s may descend / traverse the children of the given <code>node</code>
     * for inclusion in the replication content. If this returns <code>false</code>, the given node itself and its
     * properties are still included in the replication content (if {@link #accepts(javax.jcr.Node) returns true and
     * properties are accepted via {@link #accepts(javax.jcr.Property)}}.
     *
     * @param node The {@link Node} to check.
     * @return <code>true</code> if the content builder may traverse the children of the given node, <code>false</code>
     *         otherwise.
     */
    boolean allowsDescent(Node node);

    /**
     * Get the {@link List} of paths that have been filtered by this filter.
     *
     * @return a {@link} List of <code>String</code>s representing the filtered
     *         paths or <code>null</code> if this is not supported.
     */
    List<String> getFilteredPaths();
}
