/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.commons.collections.list;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

/**
 *  Serializable subclass of AbstractListDecorator.
 *
 *  @author Stephen Colebourne
 *  @since Commons Collections 3.1
 *
 * @deprecated Commons Collections 3 is in maintenance mode. Commons Collections 4 should be used instead.
 */
@Deprecated(since = "2021-04-30")
public abstract class AbstractSerializableListDecorator extends AbstractListDecorator implements Serializable {

    /**
     * Serialization version
     */
    private static final long serialVersionUID = 2684959196747496299L;

    /**
     * Constructor.
     */
    protected AbstractSerializableListDecorator(List list) {
        super(list);
    }

    // -----------------------------------------------------------------------
    /**
     * Write the list out using a custom routine.
     *
     * @param out  the output stream
     * @throws IOException
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(collection);
    }

    /**
     * Read the list in using a custom routine.
     *
     * @param in  the input stream
     * @throws IOException
     * @throws ClassNotFoundException
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        collection = (Collection) in.readObject();
    }
}
