/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.impl;

import com.adobe.agl.impl.CharTrie;
import com.adobe.agl.impl.ICUData;
import com.adobe.agl.impl.NormalizerImpl;
import com.adobe.agl.impl.TrieIterator;
import com.adobe.agl.impl.UBiDiProps;
import com.adobe.agl.impl.UCaseProps;
import com.adobe.agl.impl.UCharacterPropertyReader;
import com.adobe.agl.lang.UCharacter;
import com.adobe.agl.text.Normalizer;
import com.adobe.agl.text.UTF16;
import com.adobe.agl.text.UnicodeSet;
import com.adobe.agl.util.RangeValueIterator;
import com.adobe.agl.util.VersionInfo;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;

public final class UCharacterProperty {
    public CharTrie m_trie_;
    public char[] m_trieIndex_;
    public char[] m_trieData_;
    public int m_trieInitialValue_;
    public VersionInfo m_unicodeVersion_;
    private static final int GC_CN_MASK = UCharacterProperty.getMask(0);
    private static final int GC_CC_MASK = UCharacterProperty.getMask(15);
    private static final int GC_CS_MASK = UCharacterProperty.getMask(18);
    private static final int GC_ZS_MASK = UCharacterProperty.getMask(12);
    private static final int GC_ZL_MASK = UCharacterProperty.getMask(13);
    private static final int GC_ZP_MASK = UCharacterProperty.getMask(14);
    private static final int GC_Z_MASK = GC_ZS_MASK | GC_ZL_MASK | GC_ZP_MASK;
    BinaryProperties[] binProps = new BinaryProperties[]{new BinaryProperties(1, 256L), new BinaryProperties(1, 128L), new BinaryProperties(7, 0L), new BinaryProperties(7, 0L), new BinaryProperties(1, 2L), new BinaryProperties(1, 524288L), new BinaryProperties(1, 0x100000L), new BinaryProperties(1, 1024L), new BinaryProperties(1, 2048L), new BinaryProperties(5, 0L), new BinaryProperties(1, 0x4000000L), new BinaryProperties(1, 8192L), new BinaryProperties(1, 16384L), new BinaryProperties(1, 64L), new BinaryProperties(1, 4L), new BinaryProperties(1, 0x2000000L), new BinaryProperties(1, 0x1000000L), new BinaryProperties(1, 512L), new BinaryProperties(1, 32768L), new BinaryProperties(1, 65536L), new BinaryProperties(7, 0L), new BinaryProperties(1, 0x200000L), new BinaryProperties(6, 0L), new BinaryProperties(1, 32L), new BinaryProperties(1, 4096L), new BinaryProperties(1, 8L), new BinaryProperties(1, 131072L), new BinaryProperties(6, 0L), new BinaryProperties(1, 16L), new BinaryProperties(1, 262144L), new BinaryProperties(6, 0L), new BinaryProperties(1, 1L), new BinaryProperties(1, 0x800000L), new BinaryProperties(1, 0x400000L), new BinaryProperties(6, 0L), new BinaryProperties(1, 0x8000000L), new BinaryProperties(1, 0x10000000L), new BinaryProperties(5, 0L), new BinaryProperties(5, 0L), new BinaryProperties(5, 0L), new BinaryProperties(5, 0L), new BinaryProperties(5, 0L), new BinaryProperties(1, 0x20000000L), new BinaryProperties(1, 0x40000000L), new BinaryProperties(8, 0L), new BinaryProperties(1, 0L), new BinaryProperties(1, 0L), new BinaryProperties(1, 0L), new BinaryProperties(1, 0L)};
    CharTrie m_additionalTrie_;
    int[] m_additionalVectors_;
    int m_additionalColumnsCount_;
    int m_maxBlockScriptValue_;
    int m_maxJTGValue_;
    private static UCharacterProperty INSTANCE_ = null;

    public void setIndexData(CharTrie.FriendAgent friendagent) {
        this.m_trieIndex_ = friendagent.getPrivateIndex();
        this.m_trieData_ = friendagent.getPrivateData();
        this.m_trieInitialValue_ = friendagent.getPrivateInitialValue();
    }

    public final int getProperty(int ch) {
        if (ch < 55296 || ch > 56319 && ch < 65536) {
            try {
                return this.m_trieData_[(this.m_trieIndex_[ch >> 5] << 2) + (ch & 0x1F)];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return this.m_trieInitialValue_;
            }
        }
        if (ch <= 56319) {
            return this.m_trieData_[(this.m_trieIndex_[320 + (ch >> 5)] << 2) + (ch & 0x1F)];
        }
        if (ch <= 0x10FFFF) {
            return this.m_trie_.getSurrogateValue(UTF16.getLeadSurrogate(ch), (char)(ch & 0x3FF));
        }
        return this.m_trieInitialValue_;
    }

    public static int getUnsignedValue(int prop) {
        return prop >> 8 & 0xFF;
    }

    public int getAdditional(int codepoint, int column) {
        if (column == -1) {
            return this.getProperty(codepoint);
        }
        if (column < 0 || column >= this.m_additionalColumnsCount_) {
            return 0;
        }
        return this.m_additionalVectors_[this.m_additionalTrie_.getCodePointValue(codepoint) + column];
    }

    public VersionInfo getAge(int codepoint) {
        int version = this.getAdditional(codepoint, 0) >> 24;
        return VersionInfo.getInstance(version >> 4 & 0xF, version & 0xF, 0, 0);
    }

    private static final boolean isgraphPOSIX(int c) {
        return (UCharacterProperty.getMask(UCharacter.getType(c)) & (GC_CC_MASK | GC_CS_MASK | GC_CN_MASK | GC_Z_MASK)) == 0;
    }

    public boolean hasBinaryProperty(int codepoint, int property) {
        if (property < 0 || 49 <= property) {
            return false;
        }
        long mask = this.binProps[property].mask;
        int column = this.binProps[property].column;
        if (mask != 0L) {
            return (0xFFFFFFFFL & (long)this.getAdditional(codepoint, column) & mask) != 0L;
        }
        if (column == 6) {
            UCaseProps csp;
            try {
                csp = UCaseProps.getSingleton();
            }
            catch (IOException e) {
                return false;
            }
            switch (property) {
                case 22: {
                    return 1 == csp.getType(codepoint);
                }
                case 30: {
                    return 2 == csp.getType(codepoint);
                }
                case 27: {
                    return csp.isSoftDotted(codepoint);
                }
                case 34: {
                    return csp.isCaseSensitive(codepoint);
                }
            }
        } else if (column == 5) {
            switch (property) {
                case 9: {
                    return NormalizerImpl.isFullCompositionExclusion(codepoint);
                }
                case 37: {
                    return Normalizer.isNFSkippable(codepoint, Normalizer.NFD);
                }
                case 38: {
                    return Normalizer.isNFSkippable(codepoint, Normalizer.NFKD);
                }
                case 39: {
                    return Normalizer.isNFSkippable(codepoint, Normalizer.NFC);
                }
                case 40: {
                    return Normalizer.isNFSkippable(codepoint, Normalizer.NFKC);
                }
                case 41: {
                    return NormalizerImpl.isCanonSafeStart(codepoint);
                }
            }
        } else if (column == 7) {
            UBiDiProps bdp;
            try {
                bdp = UBiDiProps.getSingleton();
            }
            catch (IOException e) {
                return false;
            }
            switch (property) {
                case 3: {
                    return bdp.isMirrored(codepoint);
                }
                case 2: {
                    return bdp.isBidiControl(codepoint);
                }
                case 20: {
                    return bdp.isJoinControl(codepoint);
                }
            }
        } else if (column == 1) {
            switch (property) {
                case 45: {
                    if (codepoint <= 159) {
                        return codepoint == 9 || codepoint == 32;
                    }
                    return UCharacter.getType(codepoint) == 12;
                }
                case 46: {
                    return UCharacterProperty.isgraphPOSIX(codepoint);
                }
                case 47: {
                    return UCharacter.getType(codepoint) == 12 || UCharacterProperty.isgraphPOSIX(codepoint);
                }
                case 48: {
                    if (codepoint <= 102 && codepoint >= 65 && (codepoint <= 70 || codepoint >= 97) || codepoint >= 65313 && codepoint <= 65350 && (codepoint <= 65318 || codepoint >= 65345)) {
                        return true;
                    }
                    return UCharacter.getType(codepoint) == 9;
                }
            }
        } else if (column == 8) {
            switch (property) {
                case 44: {
                    return UCharacter.isUAlphabetic(codepoint) || UCharacter.isDigit(codepoint);
                }
            }
        }
        return false;
    }

    public final int getSource(int which) {
        if (which < 0) {
            return 0;
        }
        if (which < 49) {
            if (this.binProps[which].mask != 0L) {
                return 2;
            }
            return this.binProps[which].column;
        }
        if (which < 4096) {
            return 0;
        }
        if (which < 4117) {
            switch (which) {
                case 4101: 
                case 4105: {
                    return 1;
                }
                case 4107: {
                    return 3;
                }
                case 4098: 
                case 4108: 
                case 4109: 
                case 4110: 
                case 4111: 
                case 4112: 
                case 4113: {
                    return 5;
                }
                case 4096: 
                case 4102: 
                case 4103: {
                    return 7;
                }
            }
            return 2;
        }
        if (which < 16384) {
            switch (which) {
                case 8192: 
                case 12288: {
                    return 1;
                }
            }
            return 0;
        }
        if (which < 16397) {
            switch (which) {
                case 16384: {
                    return 2;
                }
                case 16385: {
                    return 7;
                }
                case 16386: 
                case 16388: 
                case 16390: 
                case 16391: 
                case 16392: 
                case 16393: 
                case 16394: 
                case 16396: {
                    return 6;
                }
                case 16387: 
                case 16389: 
                case 16395: {
                    return 4;
                }
            }
            return 0;
        }
        return 0;
    }

    public static int getRawSupplementary(char lead, char trail) {
        return (lead << 10) + trail + -56613888;
    }

    public static UCharacterProperty getInstance() {
        if (INSTANCE_ == null) {
            try {
                INSTANCE_ = new UCharacterProperty();
            }
            catch (Exception e) {
                throw new MissingResourceException(e.getMessage(), "", "");
            }
        }
        return INSTANCE_;
    }

    public static boolean isRuleWhiteSpace(int c) {
        return c >= 9 && c <= 8233 && (c <= 13 || c == 32 || c == 133 || c == 8206 || c == 8207 || c >= 8232);
    }

    public static final int getMask(int type) {
        return 1 << type;
    }

    private UCharacterProperty() throws IOException {
        InputStream is = ICUData.getRequiredStream("data/icudt40b/uprops.icu");
        BufferedInputStream b = new BufferedInputStream(is, 25000);
        UCharacterPropertyReader reader = new UCharacterPropertyReader(b);
        reader.read(this);
        b.close();
        this.m_trie_.putIndexData(this);
    }

    public void uhst_addPropertyStarts(UnicodeSet set) {
        int value2;
        int c;
        set.add(4352);
        int value = 1;
        for (c = 4442; c <= 4447; ++c) {
            value2 = UCharacter.getIntPropertyValue(c, 4107);
            if (value == value2) continue;
            value = value2;
            set.add(c);
        }
        set.add(4448);
        value = 2;
        for (c = 4515; c <= 4519; ++c) {
            value2 = UCharacter.getIntPropertyValue(c, 4107);
            if (value == value2) continue;
            value = value2;
            set.add(c);
        }
        set.add(4520);
        value = 3;
        for (c = 4602; c <= 4607; ++c) {
            value2 = UCharacter.getIntPropertyValue(c, 4107);
            if (value == value2) continue;
            value = value2;
            set.add(c);
        }
        for (c = 44032; c < 55204; c += 28) {
            set.add(c);
            set.add(c + 1);
        }
        set.add(c);
    }

    public UnicodeSet addPropertyStarts(UnicodeSet set) {
        TrieIterator propsIter = new TrieIterator(this.m_trie_);
        RangeValueIterator.Element propsResult = new RangeValueIterator.Element();
        while (propsIter.next(propsResult)) {
            set.add(propsResult.start);
        }
        set.add(9);
        set.add(10);
        set.add(14);
        set.add(28);
        set.add(32);
        set.add(133);
        set.add(134);
        set.add(127);
        set.add(8202);
        set.add(8208);
        set.add(8298);
        set.add(8304);
        set.add(65279);
        set.add(65280);
        set.add(160);
        set.add(161);
        set.add(8199);
        set.add(8200);
        set.add(8239);
        set.add(8240);
        set.add(12295);
        set.add(12296);
        set.add(19968);
        set.add(19969);
        set.add(20108);
        set.add(20109);
        set.add(19977);
        set.add(19978);
        set.add(22235);
        set.add(22236);
        set.add(20116);
        set.add(20117);
        set.add(20845);
        set.add(20846);
        set.add(19971);
        set.add(19972);
        set.add(20843);
        set.add(20844);
        set.add(20061);
        set.add(20062);
        set.add(97);
        set.add(123);
        set.add(65);
        set.add(91);
        set.add(65345);
        set.add(65371);
        set.add(65313);
        set.add(65339);
        set.add(103);
        set.add(71);
        set.add(65351);
        set.add(65319);
        set.add(8288);
        set.add(65520);
        set.add(65532);
        set.add(917504);
        set.add(921600);
        set.add(847);
        set.add(848);
        return set;
    }

    public void upropsvec_addPropertyStarts(UnicodeSet set) {
        if (this.m_additionalColumnsCount_ > 0) {
            TrieIterator propsVectorsIter = new TrieIterator(this.m_additionalTrie_);
            RangeValueIterator.Element propsVectorsResult = new RangeValueIterator.Element();
            while (propsVectorsIter.next(propsVectorsResult)) {
                set.add(propsVectorsResult.start);
            }
        }
    }

    private static final class BinaryProperties {
        int column;
        long mask;

        public BinaryProperties(int column, long mask) {
            this.column = column;
            this.mask = mask;
        }
    }
}

