/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.sites.ui.models;

import com.petebevin.markdown.MarkdownProcessor;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class ComponentModel {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentModel.class);
    private static final String NN_DOCUMENTATION = "README.md";
    @Self
    SlingHttpServletRequest request;
    private String description;
    private String documentation;

    @PostConstruct
    public void postConstruct() throws Exception {
        String suffix = this.request.getRequestPathInfo().getSuffix();
        if (suffix == null) {
            LOG.error("Missing request suffix");
            return;
        }
        ResourceResolver resolver = this.request.getResourceResolver();
        Resource resource = resolver.getResource(suffix);
        if (resource == null) {
            LOG.error("Provided suffix doesn't map to a resource: {}", (Object)suffix);
            return;
        }
        ValueMap properties = resource.adaptTo(ValueMap.class);
        this.description = (String)((Object)properties.get("jcr:description", String.class));
        Resource documentationResource = resource.getChild(NN_DOCUMENTATION);
        if (documentationResource != null) {
            Resource docFile = documentationResource.getChild("jcr:content");
            if (docFile != null) {
                ValueMap vm = docFile.adaptTo(ValueMap.class);
                InputStream inputStream = (InputStream)((Object)vm.get("jcr:data", InputStream.class));
                String content = IOUtils.toString(inputStream);
                MarkdownProcessor mp = new MarkdownProcessor();
                this.documentation = mp.markdown(content);
            } else {
                LOG.error("Could not read documentation file contents: {}", (Object)documentationResource.getPath());
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getDocumentation() {
        return this.documentation;
    }
}

