/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.commons.editor.dialog.inherited;

import com.adobe.cq.wcm.core.components.models.Image;
import com.adobe.cq.wcm.core.components.util.ComponentUtils;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.factory.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class PageImageThumbnail {
    private static final Logger log = LoggerFactory.getLogger(PageImageThumbnail.class);
    @Self
    private SlingHttpServletRequest request;
    @SlingObject
    private ResourceResolver resourceResolver;
    @Inject
    private ModelFactory modelFactory;
    private String alt;
    private String src;
    private String componentPath;
    private String currentPagePath;
    private String configPath;

    @PostConstruct
    protected void initModel() {
        PageManager pageManager;
        this.configPath = this.request.getRequestPathInfo().getResourcePath();
        this.componentPath = this.request.getRequestPathInfo().getSuffix();
        if (StringUtils.isBlank(this.componentPath)) {
            RequestParameter itemParam = this.request.getRequestParameter("item");
            if (itemParam == null) {
                log.error("Suffix and 'item' param are blank");
                return;
            }
            this.componentPath = itemParam.getString();
        }
        if ((pageManager = this.resourceResolver.adaptTo(PageManager.class)) == null) {
            log.error("pagemanager is null");
            return;
        }
        Page targetPage = null;
        Resource component = this.resourceResolver.getResource(this.componentPath);
        if (component == null) {
            log.error("the component at {} does not exist", (Object)this.componentPath);
            return;
        }
        Page currentPage = pageManager.getContainingPage(component);
        if (currentPage != null) {
            this.currentPagePath = currentPage.getPath();
        }
        RequestParameter linkURLParam = this.request.getRequestParameter("linkURL");
        String linkURL = null;
        if (linkURLParam != null) {
            linkURL = linkURLParam.getString();
        } else {
            ValueMap properties = component.getValueMap();
            linkURL = (String)((Object)properties.get("linkURL", String.class));
        }
        targetPage = StringUtils.isNotEmpty(linkURL) ? pageManager.getPage(linkURL) : currentPage;
        if (targetPage == null) {
            log.error("page is null");
            return;
        }
        Resource featuredImage = ComponentUtils.getFeaturedImage(targetPage);
        if (featuredImage == null) {
            log.error("the featured image is null");
            return;
        }
        Image imageModel = this.modelFactory.getModelFromWrappedRequest(this.request, featuredImage, Image.class);
        if (imageModel == null) {
            log.error("the image model is null");
            return;
        }
        this.alt = imageModel.getAlt();
        this.src = imageModel.getSrc();
    }

    public String getAlt() {
        return this.alt;
    }

    public String getSrc() {
        return this.src;
    }

    public String getComponentPath() {
        return this.componentPath;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getCurrentPagePath() {
        return this.currentPagePath;
    }
}

