/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.SimpleByteWriterFactory;
import com.adobe.internal.pdftoolkit.core.filter.CustomFilterRegistry;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomFilter;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import java.util.List;
import java.util.Locale;

public class CosOpenOptions {
    private ByteWriterFactory mByteWriterFactory;
    private long mEofValue = Long.MAX_VALUE;
    private boolean mSaveInPlace = false;
    private boolean mNoPreloadXRef = false;
    private PDFFontSet fontSet;
    private Locale docLocale = Locale.US;
    private CustomFilterRegistry filterRegistry;
    private boolean mRepairEnabled = true;
    private boolean mLateRepairEnabled = true;
    private boolean mSkipCorruptObjects = false;
    private boolean mDoNotEmbedFonts = false;

    public boolean skipCorruptObjects() {
        return this.mSkipCorruptObjects;
    }

    public void setSkipCorruptObjects(boolean skipCorruptObjects) {
        this.mSkipCorruptObjects = skipCorruptObjects;
    }

    protected CosOpenOptions() {
        this.mByteWriterFactory = new SimpleByteWriterFactory();
    }

    protected CosOpenOptions(CosOpenOptions original) {
        this.mByteWriterFactory = original.mByteWriterFactory;
        this.mEofValue = original.mEofValue;
        this.mSaveInPlace = original.mSaveInPlace;
        this.mNoPreloadXRef = original.mNoPreloadXRef;
        this.fontSet = original.fontSet;
        this.docLocale = original.docLocale;
        this.filterRegistry = original.filterRegistry;
        this.mRepairEnabled = original.mRepairEnabled;
        this.mLateRepairEnabled = original.mLateRepairEnabled;
        this.mSkipCorruptObjects = original.mSkipCorruptObjects;
        this.mDoNotEmbedFonts = original.mDoNotEmbedFonts;
    }

    protected ByteWriterFactory getByteWriterFactory() {
        return this.mByteWriterFactory;
    }

    public void setByteWriterFactory(ByteWriterFactory byteWriterFactory) {
        this.mByteWriterFactory = byteWriterFactory;
    }

    protected long getEofValue() {
        return this.mEofValue;
    }

    public void setEofValue(long eofValue) {
        this.mEofValue = eofValue;
    }

    protected boolean getSaveInPlace() {
        return this.mSaveInPlace;
    }

    public void setSaveInPlace(boolean saveInPlace) {
        this.mSaveInPlace = saveInPlace;
    }

    protected boolean getNoPreloadXRef() {
        return this.mNoPreloadXRef;
    }

    public void setNoPreloadXRef(boolean noPreloadXRef) {
        this.mNoPreloadXRef = noPreloadXRef;
    }

    public Locale getDocLocale() {
        return this.docLocale;
    }

    public void setDocLocale(Locale docLocale) {
        this.docLocale = docLocale;
    }

    public PDFFontSet getFontSet() {
        return this.fontSet;
    }

    public void setFontSet(PDFFontSet fontSet) {
        this.fontSet = fontSet;
    }

    public List getRegisteredFilters() {
        return this.getCustomFilterRegistry().getRegisteredFilters();
    }

    public void registerCustomFilters(List customFilters) {
        if (customFilters == null) {
            return;
        }
        for (CustomFilter customFilter : customFilters) {
            this.procureFilterRegistry().registerFilter(customFilter);
        }
    }

    public CustomFilterRegistry getCustomFilterRegistry() {
        return this.filterRegistry;
    }

    private CustomFilterRegistry procureFilterRegistry() {
        if (this.filterRegistry == null) {
            this.filterRegistry = new CustomFilterRegistry();
        }
        return this.filterRegistry;
    }

    public void setRepairEnabled(boolean enableRepair) {
        this.mRepairEnabled = enableRepair;
    }

    public boolean getRepairEnabled() {
        return this.mRepairEnabled;
    }

    public void setLateRepairEnabled(boolean enableLateRepair) {
        this.mLateRepairEnabled = enableLateRepair;
    }

    public boolean getLateRepairEnabled() {
        return this.mLateRepairEnabled;
    }

    public boolean getDoNotEmbedFonts() {
        return this.mDoNotEmbedFonts;
    }

    public void setDoNotEmbedFonts(boolean mDoNotEmbedFonts) {
        this.mDoNotEmbedFonts = mDoNotEmbedFonts;
    }
}

