/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.LZWEngine;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LZWOutputStream
extends FilterOutputStream {
    private LZWEngine lzw;

    public LZWOutputStream(OutputStream out, FilterParams p) {
        super(out);
        this.lzw = new LZWEngine(out);
        if (p != null && p.containsKey("EarlyChange")) {
            this.lzw.setEarlyChange((Integer)p.get("EarlyChange"));
        }
    }

    public LZWOutputStream(OutputStream out) {
        this(out, null);
    }

    @Override
    public void write(int b) throws IOException {
        this.lzw.put(b & 0xFF);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int maxWrite = b.length - off;
        if (maxWrite > len) {
            maxWrite = len;
        }
        while (maxWrite-- > 0) {
            this.write(b[off++] & 0xFF);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        this.lzw.put(-1);
        super.close();
    }

    public long getTotalOut() {
        return this.lzw.getTotalOut();
    }
}

