/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.svg;

import com.adobe.xfa.ChildReln;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.Schema;
import com.adobe.xfa.SchemaStrings;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.svg.SVGNode;

public final class SVGSchema
extends Schema {
    public static final String aSVG_WIDTH = "width";
    public static final String aSVG_XFACAPTION = "Caption";
    public static final String aSVG_XFACONTENT = "Content";
    private static final String[] gSVGStrings = new String[]{"#text", "desc", "g", "line", "svg", "text", "tspan", "altGlyph", "codepage", "fill", "font-family", "font-size", "font-style", "font-weight", "height", "id", "stroke", "stroke-width", "transform", "viewBox", "width", "x", "x1", "x2", "xmlns", "y", "y1", "y2"};
    private static final SVGSchema goSVG = new SVGSchema();
    private final SchemaStrings mAttributeTags = new SchemaStrings(21);
    private final SchemaStrings mElementTags = new SchemaStrings(7);

    public static SVGSchema getSVGSchema() {
        return goSVG;
    }

    public static int getTagImpl(String aSVGName, boolean bIsElement) {
        if (aSVGName == null) {
            return -1;
        }
        int nRet = bIsElement ? SVGSchema.getSVGSchema().mElementTags.getInt(aSVGName) : SVGSchema.getSVGSchema().mAttributeTags.getInt(aSVGName);
        return nRet;
    }

    SVGSchema() {
        super("http://www.w3.org/2000/svg", 726, 746, 719, 725);
        this.schemaUsesProtos(false);
        this.initSchema();
    }

    @Override
    public String getAtom(int eTag) {
        assert (eTag >= this.mnElementMin && eTag <= this.mnAttributeMax);
        return gSVGStrings[eTag - this.mnElementMin];
    }

    @Override
    public int getAttributeTag(String aNS, String aAttrName) {
        return SVGSchema.getTagImpl(aAttrName, false);
    }

    @Override
    public int getElementTag(String aNS, String aNodeName) {
        return SVGSchema.getTagImpl(aNodeName, true);
    }

    @Override
    protected int getTextTag() {
        return 719;
    }

    @Override
    protected void initSchema() {
        super.initSchema();
        for (int i = 0; i < gSVGStrings.length; ++i) {
            String atom = gSVGStrings[i];
            if (i < 7) {
                this.mElementTags.put(atom, i + this.mnElementMin);
                continue;
            }
            if (i > 28) continue;
            this.mAttributeTags.put(atom, i - 7 + this.mnAttributeMin);
        }
        assert (gSVGStrings.length == 28);
        this.putAttribute(723, 739, null, 0, 63, 0);
        this.putAttribute(723, 733, null, 0, 63, 0);
        this.putAttribute(723, 738, null, 0, 63, 0);
        this.putElement(723, 721, ChildReln.getZeroOrMore(), 0, 63, 0);
        this.putElement(723, 722, ChildReln.getZeroOrMore(), 0, 63, 0);
        this.putAttribute(721, 737, null, 0, 63, 0);
        this.putAttribute(721, 739, null, 0, 63, 0);
        this.putAttribute(721, 733, null, 0, 63, 0);
        this.putAttribute(721, 734, null, 0, 63, 0);
        this.putElement(721, 720, ChildReln.getZeroOrOne(), 0, 63, 0);
        this.putElement(721, 722, ChildReln.getZeroOrMore(), 0, 63, 0);
        this.putElement(721, 724, ChildReln.getZeroOrMore(), 0, 63, 0);
        this.putElement(720, 719, ChildReln.getZeroOrOne(), 0, 63, 0);
        this.putElement(724, 725, ChildReln.getZeroOrMore(), 0, 63, 0);
        this.putAttribute(724, 726, null, 0, 63, 0);
        this.putAttribute(724, 729, new StringAttr("font-family", "Courier Std"), 0, 63, 0);
        this.putAttribute(724, 731, null, 0, 63, 0);
        this.putAttribute(724, 732, null, 0, 63, 0);
        this.putAttribute(724, 730, new StringAttr("font-size", "0"), 0, 63, 0);
        this.putAttribute(724, 728, new StringAttr("fill", "#000000"), 0, 63, 0);
        this.putAttribute(724, 727, null, 0, 63, 0);
        this.putAttribute(724, 737, null, 0, 63, 0);
        this.putElement(725, 719, ChildReln.getZeroOrOne(), 0, 63, 0);
        this.putAttribute(725, 740, null, 0, 63, 0);
        this.putAttribute(725, 744, null, 0, 63, 0);
        this.putAttribute(725, 729, new StringAttr("font-family", "Courier Std"), 0, 63, 0);
        this.putAttribute(725, 730, new StringAttr("font-size", "0"), 0, 63, 0);
        this.putAttribute(725, 728, new StringAttr("fill", "#000000"), 0, 63, 0);
        this.putAttribute(725, 726, null, 0, 63, 0);
        this.putAttribute(722, 741, new StringAttr("x1", "0"), 0, 63, 0);
        this.putAttribute(722, 742, new StringAttr("x2", "0"), 0, 63, 0);
        this.putAttribute(722, 745, new StringAttr("y1", "0"), 0, 63, 0);
        this.putAttribute(722, 746, new StringAttr("y2", "0"), 0, 63, 0);
        this.putAttribute(722, 735, null, 0, 63, 0);
        this.putAttribute(722, 736, new StringAttr("stroke-width", "1000"), 0, 63, 0);
    }

    @Override
    protected Element newElement(int eTag, Element parent, Node prevSibling) {
        switch (eTag) {
            case 719: 
            case 720: 
            case 721: 
            case 722: 
            case 723: 
            case 724: 
            case 725: {
                return new SVGNode(parent, prevSibling);
            }
        }
        return null;
    }
}

