/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.util;

import com.adobe.granite.auth.oauth.AccessTokenProvider;
import com.adobe.granite.crypto.CryptoException;
import com.day.cq.analytics.sitecatalyst.util.TokenProviderProxy;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public final class TokenProviderProxyImpl
implements TokenProviderProxy {
    @Reference(service=AccessTokenProvider.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, target="(&(service.factoryPid=com.adobe.granite.auth.oauth.accesstoken.provider)(name=Adobe Analytics*))", bind="bindAccessTokenProvider", unbind="unbindAccessTokenProvider")
    private volatile List<?> tokenProviders;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private Map<Map<String, String>, AccessTokenProvider> availableTokenProviders = new ConcurrentHashMap<Map<String, String>, AccessTokenProvider>();
    private static final String SERVICE_NAME = "Adobe Analytics";
    private static final String ACCESS_TOKEN_PROVIDER_FACTORY_PID = "com.adobe.granite.auth.oauth.accesstoken.provider";
    private static final String ACCESS_TOKEN_PROVIDER_NAME = "name";
    private static final String ACCESS_TOKEN_PROVIDER_TITLE = "auth.token.provider.title";
    private static final String ACCESS_TOKEN_PROVIDER_CLIENTID = "auth.token.provider.client.id";
    private static final String SERVICE_PID = "service.pid";

    @Override
    public String getAccessToken(@Nonnull String name) throws CryptoException, IOException, LoginException {
        ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", SERVICE_NAME));
        AccessTokenProvider accessTokenProvider = null;
        for (Map<String, String> infoMap : this.availableTokenProviders.keySet()) {
            if (!infoMap.get(ACCESS_TOKEN_PROVIDER_NAME).equals(name)) continue;
            accessTokenProvider = this.availableTokenProviders.get(infoMap);
            break;
        }
        if (this.log.isDebugEnabled()) {
            this.log.error("accessTokenProvider cannot be null");
        }
        return accessTokenProvider != null ? accessTokenProvider.getAccessToken(resourceResolver, resourceResolver.getUserID(), null) : null;
    }

    @Override
    @Nonnull
    public Set<Map<String, String>> getTokenProvidersInfo() {
        return this.availableTokenProviders.keySet();
    }

    @Override
    public String getApikey(String name) {
        for (Map<String, String> infoMap : this.availableTokenProviders.keySet()) {
            if (!infoMap.get(ACCESS_TOKEN_PROVIDER_NAME).equals(name)) continue;
            return infoMap.get("apikey");
        }
        this.log.error("api key is null");
        return null;
    }

    @Override
    public String getServicePid(String name) {
        for (Map<String, String> infoMap : this.availableTokenProviders.keySet()) {
            if (!infoMap.get(ACCESS_TOKEN_PROVIDER_NAME).equals(name)) continue;
            return infoMap.get("servicepid");
        }
        return null;
    }

    void bindAccessTokenProvider(AccessTokenProvider accessTokenProvider, Map<?, ?> props) {
        String name = PropertiesUtil.toString(props.get(ACCESS_TOKEN_PROVIDER_NAME), "");
        String title = PropertiesUtil.toString(props.get(ACCESS_TOKEN_PROVIDER_TITLE), "");
        String apikey = PropertiesUtil.toString(props.get(ACCESS_TOKEN_PROVIDER_CLIENTID), "");
        String servicepid = PropertiesUtil.toString(props.get(SERVICE_PID), "");
        if (StringUtils.isNotBlank(name) && name.startsWith(SERVICE_NAME) && StringUtils.isNotBlank(title) && StringUtils.isNotBlank(apikey) && StringUtils.isNotBlank(servicepid)) {
            HashMap<String, String> tokenProviderInfo = new HashMap<String, String>();
            tokenProviderInfo.put(ACCESS_TOKEN_PROVIDER_NAME, name);
            tokenProviderInfo.put("title", title);
            tokenProviderInfo.put("apikey", apikey);
            tokenProviderInfo.put("servicepid", servicepid);
            this.availableTokenProviders.put(tokenProviderInfo, accessTokenProvider);
        }
    }

    void unbindAccessTokenProvider(AccessTokenProvider accessTokenProvider, Map<?, ?> props) {
        String name = PropertiesUtil.toString(props.get(ACCESS_TOKEN_PROVIDER_NAME), "");
        String title = PropertiesUtil.toString(props.get(ACCESS_TOKEN_PROVIDER_TITLE), "");
        String apikey = PropertiesUtil.toString(props.get(ACCESS_TOKEN_PROVIDER_CLIENTID), "");
        String servicepid = PropertiesUtil.toString(props.get(SERVICE_PID), "");
        if (StringUtils.isNotBlank(name) && name.startsWith(SERVICE_NAME) && StringUtils.isNotBlank(title) && StringUtils.isNotBlank(apikey) && StringUtils.isNotBlank(servicepid)) {
            HashMap<String, String> tokenProviderInfo = new HashMap<String, String>();
            tokenProviderInfo.put(ACCESS_TOKEN_PROVIDER_NAME, name);
            tokenProviderInfo.put("title", title);
            tokenProviderInfo.put("apikey", apikey);
            tokenProviderInfo.put("servicepid", servicepid);
            this.availableTokenProviders.remove(tokenProviderInfo);
        }
    }
}

