/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.adobe.granite.asset.api.Asset;
import com.adobe.granite.asset.api.AssetManager;
import com.day.cq.dam.api.s7dam.set.ImageSet;
import com.day.cq.dam.api.s7dam.set.MediaSet;
import com.day.cq.dam.api.s7dam.set.SpinSet;
import com.day.cq.dam.api.s7dam.set.SwatchSet;
import java.util.Map;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

public class S7SetHelper {
    private static String MIME_TYPE = "Multipart/Related; type=application/x-";

    public static ImageSet createS7ImageSet(Resource parent, String name, Map<String, Object> props) throws PersistenceException {
        Resource resource = S7SetHelper.createS7Set(parent, name, props, "ImageSet");
        return resource.adaptTo(ImageSet.class);
    }

    private static Resource createS7Set(Resource parent, String name, Map<String, Object> props, String type) throws PersistenceException {
        return S7SetHelper.createS7Set(parent, name, props, type, null);
    }

    private static Resource createS7Set(Resource parent, String name, Map<String, Object> props, String type, Map<String, Object> metadata) throws PersistenceException {
        if (parent != null && name != null) {
            ResourceResolver resolver = parent.getResourceResolver();
            String path = parent.getPath() + "/" + name;
            AssetManager am = resolver.adaptTo(AssetManager.class);
            Asset asset = am.createAsset(path);
            ValueMap vm = asset.adaptTo(ValueMap.class);
            vm.put("dam:s7damType", type);
            if (props != null) {
                vm.putAll(props);
            }
            Resource metadataResource = resolver.getResource(asset, "jcr:content/metadata");
            ModifiableValueMap metadataVm = metadataResource.adaptTo(ModifiableValueMap.class);
            metadataVm.put("dc:format", MIME_TYPE + type);
            if (metadata != null) {
                metadataVm.putAll(metadata);
            }
            resolver.commit();
            return resolver.getResource(path);
        }
        throw new IllegalArgumentException("parent resource or name can not be null");
    }

    public static SwatchSet createS7SwatchSet(Resource parent, String name, Map<String, Object> props) throws PersistenceException {
        Resource resource = S7SetHelper.createS7Set(parent, name, props, "SwatchSet");
        return resource.adaptTo(SwatchSet.class);
    }

    public static MediaSet createS7VideoSet(Resource parent, String name, Map<String, Object> props) throws PersistenceException {
        Resource resource = S7SetHelper.createS7Set(parent, name, props, "VideoSet");
        return resource.adaptTo(MediaSet.class);
    }

    public static MediaSet createS7MixedMediaSet(Resource parent, String name, Map<String, Object> props) throws PersistenceException {
        Resource resource = S7SetHelper.createS7Set(parent, name, props, "MixedMediaSet");
        return resource.adaptTo(MediaSet.class);
    }

    public static SpinSet createS7SpinSet(Resource parent, String name, Map<String, Object> props) throws PersistenceException {
        Resource resource = S7SetHelper.createS7Set(parent, name, props, "SpinSet");
        return resource.adaptTo(SpinSet.class);
    }

    public static boolean isS7Set(Resource resource) {
        ValueMap vm;
        String s7Type;
        Resource contentResource = resource.getChild("jcr:content");
        return contentResource != null && ("ImageSet".equals(s7Type = (vm = contentResource.adaptTo(ValueMap.class)).get("dam:s7damType", "")) || "SwatchSet".equals(s7Type) || "VideoSet".equals(s7Type) || "MixedMediaSet".equals(s7Type) || "SpinSet".equals(s7Type) || "CarouselSet".equals(s7Type) || "ECatalog".equals(s7Type));
    }

    public static boolean isS7Video(Resource resource) {
        Resource contentResource = resource.getChild("jcr:content");
        if (contentResource != null) {
            ValueMap vm = contentResource.adaptTo(ValueMap.class);
            String s7Type = vm.get("dam:s7damType", "");
            boolean isVideo = "Video".equals(s7Type) || "VideoAVS".equals(s7Type);
            return isVideo;
        }
        return false;
    }
}

