/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import com.google.common.cache.Cache;
import com.google.common.cache.Weigher;
import java.util.Map;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.plugins.blob.DataStoreCacheStatsMBean;

class FileCacheStats
extends CacheStats
implements DataStoreCacheStatsMBean {
    private static final long KB = 4096L;
    private final Weigher<Object, Object> memWeigher;
    private final Weigher<Object, Object> weigher;
    private final Cache<Object, Object> cache;

    public FileCacheStats(Cache<?, ?> cache, Weigher<?, ?> weigher, Weigher<?, ?> memWeigher, long maxWeight) {
        super(cache, "DataStore-DownloadCache", weigher, maxWeight);
        this.memWeigher = memWeigher;
        this.weigher = weigher;
        this.cache = cache;
    }

    @Override
    public long estimateCurrentMemoryWeight() {
        if (this.memWeigher == null) {
            return -1L;
        }
        long size = 0L;
        for (Map.Entry e : this.cache.asMap().entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            size += (long)this.memWeigher.weigh(k, v);
        }
        return size;
    }

    @Override
    public long estimateCurrentWeight() {
        if (this.weigher == null) {
            return -1L;
        }
        long size = 0L;
        for (Map.Entry e : this.cache.asMap().entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            size += (long)this.weigher.weigh(k, v) * 4096L;
        }
        return size;
    }
}

