/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDDestinationOrAction;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDSimpleFileSpecification;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionImportData;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionLaunch;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionRemoteGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.action.PDAnnotationAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.action.PDDocumentCatalogAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.action.PDPageAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.pdmodel.interactive.form.PDXFAResource;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Font;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PDF;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ocr.TesseractOCRConfig;
import org.apache.tika.parser.ocr.TesseractOCRParser;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.parser.pdf.XFAExtractor;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class AbstractPDF2XHTML
extends PDFTextStripper {
    private static final int MAX_ACROFORM_RECURSIONS = 10;
    private static final TesseractOCRConfig DEFAULT_TESSERACT_CONFIG = new TesseractOCRConfig();
    private static final MediaType XFA_MEDIA_TYPE = MediaType.application("vnd.adobe.xdp+xml");
    private static final MediaType XMP_MEDIA_TYPE = MediaType.application("rdf+xml");
    public static final String XMP_DOCUMENT_CATALOG_LOCATION = "documentCatalog";
    public static final String XMP_PAGE_LOCATION_PREFIX = "page ";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ROOT);
    final List<IOException> exceptions = new ArrayList<IOException>();
    final PDDocument pdDocument;
    final XHTMLContentHandler xhtml;
    final ParseContext context;
    final Metadata metadata;
    final EmbeddedDocumentExtractor embeddedDocumentExtractor;
    final PDFParserConfig config;
    final TesseractOCRParser tesseractOCRParser;
    int pageIndex = 0;
    int startPage = -1;
    int unmappedUnicodeCharsPerPage = 0;
    int totalCharsPerPage = 0;
    private final Set<String> fontNames = new HashSet<String>();

    AbstractPDF2XHTML(PDDocument pdDocument, ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws IOException {
        this.pdDocument = pdDocument;
        this.xhtml = new XHTMLContentHandler(handler, metadata);
        this.context = context;
        this.metadata = metadata;
        this.config = config;
        this.embeddedDocumentExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context);
        this.tesseractOCRParser = config.getOcrStrategy() == PDFParserConfig.OCR_STRATEGY.NO_OCR ? null : (TesseractOCRParser)EmbeddedDocumentUtil.tryToFindExistingLeafParser(TesseractOCRParser.class, context);
    }

    protected void startPage(PDPage page) throws IOException {
        try {
            this.xhtml.startElement("div", "class", "page");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a page", e);
        }
        this.writeParagraphStart();
    }

    private void extractXMPXFA(PDDocument pdfDocument, Metadata parentMetadata, ParseContext context) throws IOException, SAXException {
        Set<MediaType> supportedTypes = Collections.EMPTY_SET;
        Parser embeddedParser = context.get(Parser.class);
        if (embeddedParser != null) {
            supportedTypes = embeddedParser.getSupportedTypes(context);
        }
        if (supportedTypes.contains(XMP_MEDIA_TYPE)) {
            if (pdfDocument.getDocumentCatalog().getMetadata() != null) {
                try {
                    InputStream is = pdfDocument.getDocumentCatalog().getMetadata().exportXMPMetadata();
                    Object object = null;
                    try {
                        this.extractXMPAsEmbeddedFile(is, XMP_DOCUMENT_CATALOG_LOCATION);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (is != null) {
                            if (object != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    EmbeddedDocumentUtil.recordEmbeddedStreamException(e, parentMetadata);
                }
            }
            int pageNumber = 1;
            for (PDPage page : pdfDocument.getPages()) {
                if (page.getMetadata() != null) {
                    try (InputStream is = page.getMetadata().exportXMPMetadata();){
                        this.extractXMPAsEmbeddedFile(is, XMP_PAGE_LOCATION_PREFIX + pageNumber);
                    }
                    catch (IOException e) {
                        EmbeddedDocumentUtil.recordEmbeddedStreamException(e, parentMetadata);
                    }
                }
                ++pageNumber;
            }
        }
        if (pdfDocument.getDocumentCatalog().getAcroForm() != null && pdfDocument.getDocumentCatalog().getAcroForm().getXFA() != null) {
            Metadata xfaMetadata = new Metadata();
            xfaMetadata.set("Content-Type", XFA_MEDIA_TYPE.toString());
            xfaMetadata.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.METADATA.toString());
            if (this.embeddedDocumentExtractor.shouldParseEmbedded(xfaMetadata) && supportedTypes.contains(XFA_MEDIA_TYPE)) {
                byte[] bytes = null;
                try {
                    bytes = pdfDocument.getDocumentCatalog().getAcroForm().getXFA().getBytes();
                }
                catch (IOException e) {
                    EmbeddedDocumentUtil.recordEmbeddedStreamException(e, parentMetadata);
                }
                if (bytes != null) {
                    try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
                        this.parseMetadata(is, xfaMetadata);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractXMPAsEmbeddedFile(InputStream is, String location) throws IOException, SAXException {
        if (is == null) {
            return;
        }
        Metadata xmpMetadata = new Metadata();
        xmpMetadata.set("Content-Type", XMP_MEDIA_TYPE.toString());
        xmpMetadata.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.METADATA.toString());
        xmpMetadata.set(PDF.XMP_LOCATION, location);
        if (this.embeddedDocumentExtractor.shouldParseEmbedded(xmpMetadata)) {
            try {
                this.parseMetadata(is, xmpMetadata);
            }
            finally {
                org.apache.tika.io.IOUtils.closeQuietly(is);
            }
        }
    }

    private void parseMetadata(InputStream stream, Metadata embeddedMetadata) throws IOException, SAXException {
        try {
            this.embeddedDocumentExtractor.parseEmbedded(stream, new EmbeddedContentHandler(this.xhtml), embeddedMetadata, false);
        }
        catch (IOException e) {
            this.handleCatchableIOE(e);
        }
    }

    private void extractEmbeddedDocuments(PDDocument document) throws IOException, SAXException, TikaException {
        PDDocumentNameDictionary namesDictionary = new PDDocumentNameDictionary(document.getDocumentCatalog());
        PDEmbeddedFilesNameTreeNode efTree = namesDictionary.getEmbeddedFiles();
        if (efTree == null) {
            return;
        }
        Map embeddedFileNames = efTree.getNames();
        if (embeddedFileNames != null) {
            this.processEmbeddedDocNames(embeddedFileNames);
        } else {
            List kids = efTree.getKids();
            if (kids == null) {
                return;
            }
            for (PDNameTreeNode node : kids) {
                embeddedFileNames = node.getNames();
                if (embeddedFileNames == null) continue;
                this.processEmbeddedDocNames(embeddedFileNames);
            }
        }
    }

    private void processDoc(String name, PDFileSpecification spec, AttributesImpl attributes) throws TikaException, SAXException, IOException {
        if (spec instanceof PDSimpleFileSpecification) {
            attributes.addAttribute("", "class", "class", "CDATA", "linked");
            attributes.addAttribute("", "id", "id", "CDATA", spec.getFile());
            this.xhtml.startElement("div", attributes);
            this.xhtml.endElement("div");
        } else if (spec instanceof PDComplexFileSpecification) {
            if (attributes.getIndex("source") < 0) {
                attributes.addAttribute("", "source", "source", "CDATA", "attachment");
            }
            this.extractMultiOSPDEmbeddedFiles(name, (PDComplexFileSpecification)spec, attributes);
        }
    }

    private void processEmbeddedDocNames(Map<String, PDComplexFileSpecification> embeddedFileNames) throws IOException, SAXException, TikaException {
        if (embeddedFileNames == null || embeddedFileNames.isEmpty()) {
            return;
        }
        for (Map.Entry<String, PDComplexFileSpecification> ent : embeddedFileNames.entrySet()) {
            this.processDoc(ent.getKey(), (PDFileSpecification)ent.getValue(), new AttributesImpl());
        }
    }

    private void extractMultiOSPDEmbeddedFiles(String displayName, PDComplexFileSpecification spec, AttributesImpl attributes) throws IOException, SAXException, TikaException {
        if (spec == null) {
            return;
        }
        this.extractPDEmbeddedFile(displayName, spec.getFileUnicode(), spec.getFile(), spec.getEmbeddedFile(), attributes);
        this.extractPDEmbeddedFile(displayName, spec.getFileUnicode(), spec.getFileMac(), spec.getEmbeddedFileMac(), attributes);
        this.extractPDEmbeddedFile(displayName, spec.getFileUnicode(), spec.getFileDos(), spec.getEmbeddedFileDos(), attributes);
        this.extractPDEmbeddedFile(displayName, spec.getFileUnicode(), spec.getFileUnix(), spec.getEmbeddedFileUnix(), attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractPDEmbeddedFile(String displayName, String unicodeFileName, String fileName, PDEmbeddedFile file, AttributesImpl attributes) throws SAXException, IOException, TikaException {
        if (file == null) {
            return;
        }
        fileName = fileName == null || "".equals(fileName.trim()) ? unicodeFileName : fileName;
        fileName = fileName == null || "".equals(fileName.trim()) ? displayName : fileName;
        Metadata embeddedMetadata = new Metadata();
        embeddedMetadata.set("resourceName", fileName);
        embeddedMetadata.set("Content-Type", file.getSubtype());
        embeddedMetadata.set("Content-Length", Long.toString(file.getSize()));
        embeddedMetadata.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.toString());
        embeddedMetadata.set(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, fileName);
        if (!this.embeddedDocumentExtractor.shouldParseEmbedded(embeddedMetadata)) {
            return;
        }
        TikaInputStream stream = null;
        try {
            stream = TikaInputStream.get((InputStream)file.createInputStream());
        }
        catch (IOException e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException(e, this.metadata);
            return;
        }
        try {
            this.embeddedDocumentExtractor.parseEmbedded(stream, new EmbeddedContentHandler(this.xhtml), embeddedMetadata, false);
            attributes.addAttribute("", "class", "class", "CDATA", "embedded");
            attributes.addAttribute("", "id", "id", "CDATA", fileName);
            this.xhtml.startElement("div", attributes);
            this.xhtml.endElement("div");
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    void handleCatchableIOE(IOException e) throws IOException {
        String msg;
        if (this.config.getCatchIntermediateIOExceptions()) {
            if (e.getCause() instanceof SAXException && e.getCause().getMessage() != null && e.getCause().getMessage().contains("Your document contained more than")) {
                throw e;
            }
            msg = e.getMessage();
            if (msg == null) {
                msg = "IOException, no message";
            }
        } else {
            throw e;
        }
        this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, msg);
        this.exceptions.add(e);
    }

    void doOCROnCurrentPage() throws IOException, TikaException, SAXException {
        if (this.config.getOcrStrategy().equals((Object)PDFParserConfig.OCR_STRATEGY.NO_OCR)) {
            return;
        }
        TesseractOCRConfig tesseractConfig = this.context.get(TesseractOCRConfig.class, this.tesseractOCRParser.getDefaultConfig());
        if (!this.tesseractOCRParser.hasTesseract(tesseractConfig)) {
            throw new TikaException("Tesseract is not available. Please set the OCR_STRATEGY to NO_OCR or configure Tesseract correctly");
        }
        PDFRenderer renderer = new PDFRenderer(this.pdDocument);
        TemporaryResources tmp = new TemporaryResources();
        try {
            int dpi = this.config.getOcrDPI();
            BufferedImage image = renderer.renderImageWithDPI(this.pageIndex, (float)dpi, this.config.getOcrImageType());
            Path tmpFile = tmp.createTempFile();
            try (OutputStream os = Files.newOutputStream(tmpFile, new OpenOption[0]);){
                ImageIOUtil.writeImage((BufferedImage)image, (String)this.config.getOcrImageFormatName(), (OutputStream)os, (int)dpi, (float)this.config.getOcrImageQuality());
            }
            var8_10 = null;
            try (TikaInputStream is = TikaInputStream.get(tmpFile);){
                this.tesseractOCRParser.parseInline(is, this.xhtml, tesseractConfig);
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
        }
        catch (IOException e) {
            this.handleCatchableIOE(e);
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("error writing OCR content from PDF", e);
        }
        finally {
            tmp.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endPage(PDPage page) throws IOException {
        this.metadata.add(PDF.CHARACTERS_PER_PAGE, this.totalCharsPerPage);
        this.metadata.add(PDF.UNMAPPED_UNICODE_CHARS_PER_PAGE, this.unmappedUnicodeCharsPerPage);
        try {
            for (PDAnnotation annotation : page.getAnnotations()) {
                String link;
                if (annotation instanceof PDAnnotationFileAttachment) {
                    PDAnnotationFileAttachment fann = (PDAnnotationFileAttachment)annotation;
                    PDComplexFileSpecification fileSpec = (PDComplexFileSpecification)fann.getFile();
                    try {
                        AttributesImpl attributes = new AttributesImpl();
                        attributes.addAttribute("", "source", "source", "CDATA", "annotation");
                        this.extractMultiOSPDEmbeddedFiles(fann.getAttachmentName(), fileSpec, attributes);
                    }
                    catch (SAXException e) {
                        throw new IOExceptionWithCause("file embedded in annotation sax exception", e);
                    }
                    catch (TikaException e) {
                        throw new IOExceptionWithCause("file embedded in annotation tika exception", e);
                    }
                    catch (IOException e) {
                        this.handleCatchableIOE(e);
                    }
                } else if (annotation instanceof PDAnnotationWidget) {
                    this.handleWidget((PDAnnotationWidget)annotation);
                }
                if (!this.config.getExtractAnnotationText()) continue;
                PDActionURI uri = AbstractPDF2XHTML.getActionURI(annotation);
                if (uri != null && (link = uri.getURI()) != null && link.trim().length() > 0) {
                    this.xhtml.startElement("div", "class", "annotation");
                    this.xhtml.startElement("a", "href", link);
                    this.xhtml.characters(link);
                    this.xhtml.endElement("a");
                    this.xhtml.endElement("div");
                }
                if (!(annotation instanceof PDAnnotationMarkup)) continue;
                PDAnnotationMarkup annotationMarkup = (PDAnnotationMarkup)annotation;
                String title = annotationMarkup.getTitlePopup();
                String subject = annotationMarkup.getSubject();
                String contents = annotationMarkup.getContents();
                if (title == null && subject == null && contents == null) continue;
                this.xhtml.startElement("div", "class", "annotation");
                if (title != null) {
                    this.xhtml.startElement("div", "class", "annotationTitle");
                    this.xhtml.characters(title);
                    this.xhtml.endElement("div");
                }
                if (subject != null) {
                    this.xhtml.startElement("div", "class", "annotationSubject");
                    this.xhtml.characters(subject);
                    this.xhtml.endElement("div");
                }
                if (contents != null) {
                    this.xhtml.startElement("div", "class", "annotationContents");
                    this.xhtml.characters(contents);
                    this.xhtml.endElement("div");
                }
                this.xhtml.endElement("div");
            }
            if (this.config.getOcrStrategy().equals((Object)PDFParserConfig.OCR_STRATEGY.OCR_AND_TEXT_EXTRACTION)) {
                this.doOCROnCurrentPage();
            } else if (this.config.getOcrStrategy().equals((Object)PDFParserConfig.OCR_STRATEGY.AUTO) && (this.totalCharsPerPage < 10 || this.unmappedUnicodeCharsPerPage > 10)) {
                this.doOCROnCurrentPage();
            }
            PDPageAdditionalActions pageActions = page.getActions();
            if (pageActions != null) {
                this.handleDestinationOrAction((PDDestinationOrAction)pageActions.getC(), ActionTrigger.PAGE_CLOSE);
                this.handleDestinationOrAction((PDDestinationOrAction)pageActions.getO(), ActionTrigger.PAGE_OPEN);
            }
            this.xhtml.endElement("div");
        }
        catch (TikaException | SAXException e) {
            throw new IOExceptionWithCause("Unable to end a page", e);
        }
        catch (IOException e) {
            this.handleCatchableIOE(e);
        }
        finally {
            this.totalCharsPerPage = 0;
            this.unmappedUnicodeCharsPerPage = 0;
        }
        if (this.config.getExtractFontNames()) {
            for (COSName n : page.getResources().getFontNames()) {
                String fontName;
                PDFont font = page.getResources().getFont(n);
                if (font == null || font.getFontDescriptor() == null || (fontName = font.getFontDescriptor().getFontName()) == null) continue;
                this.fontNames.add(fontName);
            }
        }
    }

    private void handleWidget(PDAnnotationWidget widget) throws TikaException, SAXException, IOException {
        if (widget == null) {
            return;
        }
        this.handleDestinationOrAction((PDDestinationOrAction)widget.getAction(), ActionTrigger.ANNOTATION_WIDGET);
        PDAnnotationAdditionalActions annotationActions = widget.getActions();
        if (annotationActions != null) {
            this.handleDestinationOrAction((PDDestinationOrAction)annotationActions.getBl(), ActionTrigger.ANNOTATION_LOSE_INPUT_FOCUS);
            this.handleDestinationOrAction((PDDestinationOrAction)annotationActions.getD(), ActionTrigger.ANNOTATION_MOUSE_CLICK);
            this.handleDestinationOrAction((PDDestinationOrAction)annotationActions.getE(), ActionTrigger.ANNOTATION_CURSOR_ENTERS);
            this.handleDestinationOrAction((PDDestinationOrAction)annotationActions.getFo(), ActionTrigger.ANNOTATION_RECEIVES_FOCUS);
            this.handleDestinationOrAction((PDDestinationOrAction)annotationActions.getPC(), ActionTrigger.ANNOTATION_PAGE_CLOSED);
            this.handleDestinationOrAction((PDDestinationOrAction)annotationActions.getPI(), ActionTrigger.ANNOTATION_PAGE_NO_LONGER_VISIBLE);
            this.handleDestinationOrAction((PDDestinationOrAction)annotationActions.getPO(), ActionTrigger.ANNOTATION_PAGE_OPENED);
            this.handleDestinationOrAction((PDDestinationOrAction)annotationActions.getPV(), ActionTrigger.ANNOTATION_PAGE_VISIBLE);
            this.handleDestinationOrAction((PDDestinationOrAction)annotationActions.getU(), ActionTrigger.ANNOTATION_MOUSE_RELEASED);
            this.handleDestinationOrAction((PDDestinationOrAction)annotationActions.getX(), ActionTrigger.ANNOTATION_CURSOR_EXIT);
        }
    }

    protected void startDocument(PDDocument pdf) throws IOException {
        try {
            this.xhtml.startDocument();
            try {
                this.handleDestinationOrAction(pdf.getDocumentCatalog().getOpenAction(), ActionTrigger.DOCUMENT_OPEN);
            }
            catch (IOException iOException) {}
        }
        catch (TikaException | SAXException e) {
            throw new IOExceptionWithCause("Unable to start a document", e);
        }
    }

    private void handleDestinationOrAction(PDDestinationOrAction action, ActionTrigger actionTrigger) throws IOException, SAXException, TikaException {
        if (action == null || !this.config.getExtractActions()) {
            return;
        }
        AttributesImpl attributes = new AttributesImpl();
        String actionOrDestString = action instanceof PDAction ? "action" : "destination";
        AbstractPDF2XHTML.addNonNullAttribute("class", actionOrDestString, attributes);
        AbstractPDF2XHTML.addNonNullAttribute("type", action.getClass().getSimpleName(), attributes);
        AbstractPDF2XHTML.addNonNullAttribute("trigger", actionTrigger.name(), attributes);
        if (action instanceof PDActionImportData) {
            this.processDoc("", ((PDActionImportData)action).getFile(), attributes);
        } else if (action instanceof PDActionLaunch) {
            PDActionLaunch pdActionLaunch = (PDActionLaunch)action;
            AbstractPDF2XHTML.addNonNullAttribute("id", pdActionLaunch.getF(), attributes);
            AbstractPDF2XHTML.addNonNullAttribute("defaultDirectory", pdActionLaunch.getD(), attributes);
            AbstractPDF2XHTML.addNonNullAttribute("operation", pdActionLaunch.getO(), attributes);
            AbstractPDF2XHTML.addNonNullAttribute("parameters", pdActionLaunch.getP(), attributes);
            this.processDoc(pdActionLaunch.getF(), pdActionLaunch.getFile(), attributes);
        } else if (action instanceof PDActionRemoteGoTo) {
            PDActionRemoteGoTo remoteGoTo = (PDActionRemoteGoTo)action;
            this.processDoc("", remoteGoTo.getFile(), attributes);
        } else if (action instanceof PDActionJavaScript) {
            PDActionJavaScript jsAction = (PDActionJavaScript)action;
            Metadata m = new Metadata();
            m.set("Content-Type", "application/javascript");
            m.set("Content-Encoding", StandardCharsets.UTF_8.toString());
            m.set(PDF.ACTION_TRIGGER, actionTrigger.toString());
            m.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.MACRO.name());
            String js = jsAction.getAction();
            String string = js = js == null ? "" : js;
            if (this.embeddedDocumentExtractor.shouldParseEmbedded(m)) {
                try (TikaInputStream is = TikaInputStream.get(js.getBytes(StandardCharsets.UTF_8));){
                    this.embeddedDocumentExtractor.parseEmbedded(is, this.xhtml, m, false);
                }
            }
            AbstractPDF2XHTML.addNonNullAttribute("class", "javascript", attributes);
            AbstractPDF2XHTML.addNonNullAttribute("type", jsAction.getType(), attributes);
            AbstractPDF2XHTML.addNonNullAttribute("subtype", jsAction.getSubType(), attributes);
            this.xhtml.startElement("div", attributes);
            this.xhtml.endElement("div");
        } else {
            this.xhtml.startElement("div", attributes);
            this.xhtml.endElement("div");
        }
    }

    private static void addNonNullAttribute(String name, String value, AttributesImpl attributes) {
        if (name == null || value == null) {
            return;
        }
        attributes.addAttribute("", name, name, "CDATA", value);
    }

    protected void endDocument(PDDocument pdf) throws IOException {
        try {
            if (this.config.getExtractBookmarksText()) {
                this.extractBookmarkText();
            }
            try {
                this.extractEmbeddedDocuments(pdf);
            }
            catch (IOException e) {
                this.handleCatchableIOE(e);
            }
            this.extractXMPXFA(pdf, this.metadata, this.context);
            if (this.config.getExtractAcroFormContent()) {
                try {
                    this.extractAcroForm(pdf);
                }
                catch (IOException e) {
                    this.handleCatchableIOE(e);
                }
            }
            PDDocumentCatalogAdditionalActions additionalActions = pdf.getDocumentCatalog().getActions();
            this.handleDestinationOrAction((PDDestinationOrAction)additionalActions.getDP(), ActionTrigger.AFTER_DOCUMENT_PRINT);
            this.handleDestinationOrAction((PDDestinationOrAction)additionalActions.getDS(), ActionTrigger.AFTER_DOCUMENT_SAVE);
            this.handleDestinationOrAction((PDDestinationOrAction)additionalActions.getWC(), ActionTrigger.BEFORE_DOCUMENT_CLOSE);
            this.handleDestinationOrAction((PDDestinationOrAction)additionalActions.getWP(), ActionTrigger.BEFORE_DOCUMENT_PRINT);
            this.handleDestinationOrAction((PDDestinationOrAction)additionalActions.getWS(), ActionTrigger.BEFORE_DOCUMENT_SAVE);
            this.xhtml.endDocument();
        }
        catch (TikaException e) {
            throw new IOExceptionWithCause("Unable to end a document", e);
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a document", e);
        }
        if (this.fontNames.size() > 0) {
            for (String fontName : this.fontNames) {
                this.metadata.add(Font.FONT_NAME, fontName);
            }
        }
    }

    void extractBookmarkText() throws SAXException, IOException, TikaException {
        PDDocumentOutline outline = this.document.getDocumentCatalog().getDocumentOutline();
        if (outline != null) {
            this.extractBookmarkText((PDOutlineNode)outline);
        }
    }

    void extractBookmarkText(PDOutlineNode bookmark) throws SAXException, IOException, TikaException {
        PDOutlineItem current = bookmark.getFirstChild();
        if (current != null) {
            this.xhtml.startElement("ul");
            while (current != null) {
                this.xhtml.startElement("li");
                this.xhtml.characters(current.getTitle());
                this.xhtml.endElement("li");
                this.handleDestinationOrAction((PDDestinationOrAction)current.getAction(), ActionTrigger.BOOKMARK);
                this.extractBookmarkText((PDOutlineNode)current);
                current = current.getNextSibling();
            }
            this.xhtml.endElement("ul");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void extractAcroForm(PDDocument pdf) throws IOException, SAXException, TikaException {
        List fields;
        PDDocumentCatalog catalog = pdf.getDocumentCatalog();
        if (catalog == null) {
            return;
        }
        PDAcroForm form = catalog.getAcroForm();
        if (form == null) {
            return;
        }
        PDXFAResource pdxfa = form.getXFA();
        if (pdxfa != null) {
            XFAExtractor xfaExtractor = new XFAExtractor();
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new ByteArrayInputStream(pdxfa.getBytes()));
            }
            catch (IOException e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException(e, this.metadata);
            }
            if (is != null) {
                try {
                    xfaExtractor.extract(is, this.xhtml, this.metadata, this.context);
                    return;
                }
                catch (XMLStreamException e) {
                    EmbeddedDocumentUtil.recordException(e, this.metadata);
                }
                finally {
                    IOUtils.closeQuietly(is);
                }
            }
        }
        if ((fields = form.getFields()) == null) {
            return;
        }
        ListIterator itr = fields.listIterator();
        if (itr == null) {
            return;
        }
        this.xhtml.startElement("div", "class", "acroform");
        this.xhtml.startElement("ol");
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (obj == null || !(obj instanceof PDField)) continue;
            this.processAcroField((PDField)obj, 0);
        }
        this.xhtml.endElement("ol");
        this.xhtml.endElement("div");
    }

    private void processAcroField(PDField field, int currentRecursiveDepth) throws SAXException, IOException, TikaException {
        if (currentRecursiveDepth >= 10) {
            return;
        }
        PDFormFieldAdditionalActions pdFormFieldAdditionalActions = field.getActions();
        if (pdFormFieldAdditionalActions != null) {
            this.handleDestinationOrAction((PDDestinationOrAction)pdFormFieldAdditionalActions.getC(), ActionTrigger.FORM_FIELD_RECALCULATE);
            this.handleDestinationOrAction((PDDestinationOrAction)pdFormFieldAdditionalActions.getF(), ActionTrigger.FORM_FIELD_FORMATTED);
            this.handleDestinationOrAction((PDDestinationOrAction)pdFormFieldAdditionalActions.getK(), ActionTrigger.FORM_FIELD_KEYSTROKE);
            this.handleDestinationOrAction((PDDestinationOrAction)pdFormFieldAdditionalActions.getV(), ActionTrigger.FORM_FIELD_VALUE_CHANGE);
        }
        if (field.getWidgets() != null) {
            for (PDAnnotationWidget widget : field.getWidgets()) {
                this.handleWidget(widget);
            }
        }
        this.addFieldString(field);
        if (field instanceof PDNonTerminalField) {
            int r = currentRecursiveDepth + 1;
            this.xhtml.startElement("ol");
            for (PDField child : ((PDNonTerminalField)field).getChildren()) {
                this.processAcroField(child, r);
            }
            this.xhtml.endElement("ol");
        }
    }

    private void addFieldString(PDField field) throws SAXException {
        String partName = field.getPartialName();
        String altName = field.getAlternateFieldName();
        StringBuilder sb = new StringBuilder();
        AttributesImpl attrs = new AttributesImpl();
        if (partName != null) {
            sb.append(partName).append(": ");
        }
        if (altName != null) {
            attrs.addAttribute("", "altName", "altName", "CDATA", altName);
        }
        if (field instanceof PDSignatureField) {
            this.handleSignature(attrs, (PDSignatureField)field);
            return;
        }
        String value = field.getValueAsString();
        if (value != null && !value.equals("null")) {
            sb.append(value);
        }
        if (attrs.getLength() > 0 || sb.length() > 0) {
            this.xhtml.startElement("li", attrs);
            this.xhtml.characters(sb.toString());
            this.xhtml.endElement("li");
        }
    }

    private void handleSignature(AttributesImpl parentAttributes, PDSignatureField sigField) throws SAXException {
        PDSignature sig = sigField.getSignature();
        if (sig == null) {
            return;
        }
        TreeMap<String, String> vals = new TreeMap<String, String>();
        vals.put("name", sig.getName());
        vals.put("contactInfo", sig.getContactInfo());
        vals.put("location", sig.getLocation());
        vals.put("reason", sig.getReason());
        Calendar cal = sig.getSignDate();
        if (cal != null) {
            this.dateFormat.setTimeZone(cal.getTimeZone());
            vals.put("date", this.dateFormat.format(cal.getTime()));
        }
        int nonNull = 0;
        for (String val : vals.keySet()) {
            if (val == null || val.equals("")) continue;
            ++nonNull;
        }
        if (nonNull > 0) {
            this.metadata.set(TikaCoreProperties.HAS_SIGNATURE, "true");
            this.xhtml.startElement("li", parentAttributes);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "type", "type", "CDATA", "signaturedata");
            this.xhtml.startElement("ol", attrs);
            for (Map.Entry e : vals.entrySet()) {
                if (e.getValue() == null || ((String)e.getValue()).equals("")) continue;
                attrs = new AttributesImpl();
                attrs.addAttribute("", "signdata", "signdata", "CDATA", (String)e.getKey());
                this.xhtml.startElement("li", attrs);
                this.xhtml.characters((String)e.getValue());
                this.xhtml.endElement("li");
            }
            this.xhtml.endElement("ol");
            this.xhtml.endElement("li");
        }
    }

    private static PDActionURI getActionURI(PDAnnotation annot) {
        try {
            PDAction action;
            Method actionMethod = annot.getClass().getDeclaredMethod("getAction", new Class[0]);
            if (actionMethod.getReturnType().equals(PDAction.class) && (action = (PDAction)actionMethod.invoke((Object)annot, new Object[0])) instanceof PDActionURI) {
                return (PDActionURI)action;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    public int getCurrentPageNo() {
        return this.pageIndex + 1;
    }

    protected void processPages(PDPageTree pages) throws IOException {
        super.setStartPage(-1);
        for (PDPage page : pages) {
            if (this.getCurrentPageNo() >= this.getStartPage() && this.getCurrentPageNo() <= this.getEndPage()) {
                this.processPage(page);
            }
            ++this.pageIndex;
        }
    }

    public void setStartBookmark(PDOutlineItem pdOutlineItem) {
        throw new UnsupportedOperationException("We don't currently support this -- See PDFTextStripper's processPages() for how to implement this.");
    }

    public void setEndBookmark(PDOutlineItem pdOutlineItem) {
        throw new UnsupportedOperationException("We don't currently support this -- See PDFTextStripper's processPages() for how to implement this.");
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public int getStartPage() {
        return this.startPage;
    }

    protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, String unicode, Vector displacement) throws IOException {
        super.showGlyph(textRenderingMatrix, font, code, unicode, displacement);
        if (unicode == null || unicode.isEmpty()) {
            ++this.unmappedUnicodeCharsPerPage;
        }
        ++this.totalCharsPerPage;
    }

    static enum ActionTrigger {
        AFTER_DOCUMENT_PRINT,
        AFTER_DOCUMENT_SAVE,
        ANNOTATION_CURSOR_ENTERS,
        ANNOTATION_CURSOR_EXIT,
        ANNOTATION_LOSE_INPUT_FOCUS,
        ANNOTATION_MOUSE_CLICK,
        ANNOTATION_MOUSE_RELEASED,
        ANNOTATION_PAGE_CLOSED,
        ANNOTATION_PAGE_NO_LONGER_VISIBLE,
        ANNOTATION_PAGE_OPENED,
        ANNOTATION_PAGE_VISIBLE,
        ANNOTATION_RECEIVES_FOCUS,
        ANNOTATION_WIDGET,
        BEFORE_DOCUMENT_CLOSE,
        BEFORE_DOCUMENT_PRINT,
        BEFORE_DOCUMENT_SAVE,
        DOCUMENT_OPEN,
        FORM_FIELD,
        FORM_FIELD_FORMATTED,
        FORM_FIELD_KEYSTROKE,
        FORM_FIELD_RECALCULATE,
        FORM_FIELD_VALUE_CHANGE,
        PAGE_CLOSE,
        PAGE_OPEN,
        BOOKMARK;

    }
}

